package tech.atani.client.module.impl.hud;

import org.lwjgl.input.Keyboard;
import tech.atani.client.Atani;
import tech.atani.client.event.impl.OffsetRender2DEvent;
import tech.atani.client.module.Module;
import tech.atani.client.module.data.Category;
import tech.atani.client.module.data.ModuleData;
import tech.atani.client.screen.Icon;
import tech.atani.client.util.client.events.base.Listen;
import tech.atani.client.util.client.events.base.Priority;
import tech.atani.client.util.client.language.TranslationUtil;
import tech.atani.client.util.game.render.catppuccin.Mocha;
import tech.atani.client.util.game.render.font.gui.font.renderer.SimpleFontRenderer;
import tech.atani.client.util.game.render.shader.data.renderer.Renderer;

import java.util.*;
import java.util.stream.Collectors;

@SuppressWarnings("unused")
@ModuleData(name = "Keybinds", description = "modules.keybinds.description", category = Category.HUD)
public class Keybinds extends Module {

    private final SimpleFontRenderer icon = Atani.instance.fontStorage.getFont("Icons-FilledRounded", 14).newRenderer();
    private final SimpleFontRenderer font1 = Atani.instance.fontStorage.getFont("Google-Medium", 11).newRenderer();
    private final SimpleFontRenderer font2 = Atani.instance.fontStorage.getFont("Google-Regular", 10).newRenderer();

    public Keybinds() {
        toggle();
    }

    @Listen(priority = Priority.DEFAULT)
    private void onEvent(OffsetRender2DEvent event) {
        float y = event.getOffset() + 5;
        String text = TranslationUtil.getTranslation("modules.keybinds.keybinds");
        Renderer.drawRoundedSelectiveRectangle(5, y, 120, 22, 4, Mocha.BASE.getRGB(), true, true, false, false);

        icon.drawYCenteredString(Icon.SETTINGS.letter, 9, y + 22 / 2f, -1);
        font1.drawYCenteredString(text, 120 - font1.getStringWidth(text), y + 22 / 2f, -1);

        float yOffset = y + 22 - 1;
        for (Module module : getBoundModules()) {
            boolean last = last().get() == module;

            Renderer.drawRoundedSelectiveRectangle(5, yOffset, 120, 22, 4, Mocha.MANTLE.getRGB(), false, false, last, last);

            String keyName = Keyboard.getKeyName(module.getKey());
            float boxWidth = font2.getStringWidth(keyName) + 4;
            float boxX = 11 + 120 - boxWidth - 7 - 5.5f;
            float boxY = yOffset + 5;
            Renderer.drawRoundedRect(boxX, boxY, boxWidth, 12, 3, Mocha.MANTLE.brighter());
            font2.drawXYCenteredString(keyName, boxX + boxWidth / 2f, boxY + 12 / 2f, Mocha.TEXT);

            font2.drawYCenteredString(module.getData().name(), 9 + 2, yOffset + 22 / 2f, module.isEnabled() ? Mocha.SUBTEXT_0 : Mocha.OVERLAY_0);

            if (!last)
                yOffset += 22 - 1;
        }

        event.setOffset(event.getOffset() + yOffset - 51);
    }

    private Set<Module> getBoundModules() {
        return Atani.instance.moduleStorage.getSet().stream()
                .filter(m -> m.getKey() != 0)
                .sorted(Comparator.comparingInt(m -> Keyboard.getKeyName(m.getKey()).length()))
                .collect(Collectors.toCollection(LinkedHashSet::new)).reversed();
    }

    private Optional<Module> last() {
        return getBoundModules().stream()
                .reduce((a, b) -> b);
    }
}
