package tech.atani.client.module.impl.combat;

import net.minecraft.network.play.server.S12PacketEntityVelocity;
import tech.atani.client.event.impl.MoveInputEvent;
import tech.atani.client.event.impl.PacketEvent;
import tech.atani.client.module.data.Category;
import tech.atani.client.module.Module;
import tech.atani.client.module.data.ModuleData;
import tech.atani.client.setting.impl.SliderSetting;
import tech.atani.client.setting.impl.StringSetting;
import tech.atani.client.util.client.events.base.Listen;

@ModuleData(name = "Velocity", category = Category.COMBAT, description = "modules.velocity.description")
@SuppressWarnings("unused")
public class Velocity extends Module {

    private final StringSetting mode = new StringSetting.Builder()
            .name("modules.velocity.mode")
            .value("Edit")
            .values("Edit", "Jump", "Intave")
            .build();

    private final SliderSetting horizontal = new SliderSetting.Builder()
            .name("modules.velocity.horizontal")
            .value(0)
            .min(1)
            .max(100)
            .build()
            .hide(() -> !mode.is("Edit"));

    private final SliderSetting vertical = new SliderSetting.Builder()
            .name("modules.velocity.vertical")
            .value(0)
            .min(1)
            .max(100)
            .build()
            .hide(() -> !mode.is("Edit"));

    private int velocities;

    @Override
    public void onDisable() {
        velocities = 0;
    }

    @Listen
    private void onMoveInput(MoveInputEvent event) {
        switch (mode.stringValue()) {
            case "Jump", "Intave" -> {
                if (mc.thePlayer.hurtTime == 9 && mc.thePlayer.onGround && mc.thePlayer.isSprinting()) {
                    if (mode.is("Intave") && ++velocities % 2 != 0) {
                        return;
                    }

                    event.setJumping(true);
                }
            }
        }
    }

    @Listen
    private void onPacket(PacketEvent event) {
        if (nullCheck()) {
        switch (mode.stringValue()) {
                case "Edit" -> {
                    if (event.getPacket() instanceof S12PacketEntityVelocity veloPacket) {
                        if (veloPacket.getEntityID() == mc.thePlayer.getEntityId()) {
                            if (horizontal.doubleValue() == 0 && vertical.doubleValue() == 0) {
                                event.cancelled = true;
                            }

                            veloPacket.setMotionX((int) (veloPacket.getMotionX() * (horizontal.doubleValue() / 100D)));
                            veloPacket.setMotionY((int) (veloPacket.getMotionY() * (vertical.doubleValue() / 100D)));
                            veloPacket.setMotionZ((int) (veloPacket.getMotionZ() * (horizontal.doubleValue() / 100D)));
                        }
                    }
                }
            }
        }
    }

    @Override
    public String getSuffix() {
        return mode.getValue();
    }
}