package tech.atani.client.module.impl.combat;

import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import tech.atani.client.event.impl.AttackEntityEvent;
import tech.atani.client.event.impl.MoveButtonEvent;
import tech.atani.client.module.Module;
import tech.atani.client.module.data.Category;
import tech.atani.client.module.data.ModuleData;
import tech.atani.client.setting.impl.SliderSetting;
import tech.atani.client.setting.impl.StringSetting;
import tech.atani.client.util.client.events.base.Listen;
import tech.atani.client.util.system.math.TimerUtil;

@ModuleData(name = "MoreKnockback", category = Category.COMBAT, description = "modules.moreknockback.description")
@SuppressWarnings("unused")
public class MoreKnockback extends Module {

    /*
    // sorry liticane :(
    */

    private final SliderSetting hurtTime = new SliderSetting.Builder()
            .name("modules.moreknockback.hurttime")
            .value(2)
            .min(0)
            .max(10)
            .build();

    private final SliderSetting holdTime = new SliderSetting.Builder()
            .name("modules.moreknockback.holdtime")
            .value(50)
            .min(0)
            .max(1000)
            .build();

    private final StringSetting mode = new StringSetting.Builder()
            .name("modules.moreknockback.mode")
            .value("W-Tap")
            .values("W-Tap", "S-Tap")
            .build();

    private final TimerUtil timer = new TimerUtil();
    private boolean work = false;

    @Listen
    private void onMoveInput(MoveButtonEvent event) {
        if (!timer.hasTimeElapsed(holdTime.getValue().longValue()) && work) {
            switch (mode.getValue()) {
                case "W-Tap" -> {
                    event.setForward(false);

                    mc.thePlayer.setSprinting(false);
                }
                case "S-Tap" -> {
                    event.setForward(false);
                    event.setBack(true);

                    mc.thePlayer.setSprinting(false);
                }
            }
        } else {
            timer.reset();
            work = false;
        }
    }

    @Listen
    private void onAttack(AttackEntityEvent event) {
        Entity entity = event.getEntity();

        work = entity instanceof EntityPlayer playerEntity && playerEntity.hurtTime == hurtTime.getValue();
    }

    @Override
    public String getSuffix() {
        return mode.getValue();
    }
}