package tech.atani.client.module.impl.combat;

import net.minecraft.network.play.client.C02PacketUseEntity;
import net.minecraft.network.play.client.C07PacketPlayerDigging;
import net.minecraft.network.play.client.C08PacketPlayerBlockPlacement;
import net.minecraft.util.BlockPos;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.MovingObjectPosition;
import org.lwjgl.util.vector.Vector2f;
import tech.atani.client.event.impl.*;
import tech.atani.client.module.Module;
import tech.atani.client.module.data.Category;
import tech.atani.client.module.data.ModuleData;
import tech.atani.client.setting.impl.CheckBoxSetting;
import tech.atani.client.setting.impl.MultiSelectSetting;
import tech.atani.client.setting.impl.StringSetting;
import tech.atani.client.setting.impl.SliderSetting;
import tech.atani.client.util.client.events.base.Listen;
import tech.atani.client.util.client.events.base.Priority;
import tech.atani.client.util.game.entity.EntityUtil;
import tech.atani.client.util.game.entity.RayCastUtil;
import tech.atani.client.util.game.player.ClickUtils;
import tech.atani.client.util.game.player.RotationUtil;
import tech.atani.client.util.game.player.SmoothUtil;
import tech.atani.client.util.system.math.TimerUtil;

import java.security.SecureRandom;

@SuppressWarnings("unused")
@ModuleData(name = "KillAura", category = Category.COMBAT, description = "modules.killaura.description")
public class KillAura extends Module {
    private final SliderSetting aimRange = new SliderSetting.Builder()
            .name("modules.killaura.aimrange")
            .value(4)
            .min(1)
            .max(6)
            .increment(1)
            .build();

    public final SliderSetting attackRange = new SliderSetting.Builder()
            .name("modules.killaura.attackrange")
            .value(4)
            .min(1)
            .max(6)
            .increment(1)
            .build();

    public final StringSetting attackMode = new StringSetting.Builder()
            .name("Attack Mode")
            .value("Minecraft")
            .values("Minecraft", "Blatant")
            .build();

    private final SliderSetting minCPS = new SliderSetting.Builder()
            .name("modules.killaura.mincps")
            .value(11)
            .min(1)
            .max(20)
            .build();

    private final SliderSetting maxCPS = new SliderSetting.Builder()
            .name("modules.killaura.maxcps")
            .value(14)
            .min(1)
            .max(20)
            .build();

    public final CheckBoxSetting perfectHit = new CheckBoxSetting.Builder()
            .name("modules.killaura.perfecthit")
            .value(true)
            .build();

    public final StringSetting mode = new StringSetting.Builder()
            .name("modules.killaura.mode")
            .value("Distance")
            .values("Distance", "Health", "Hurt-time")
            .build();

    public final MultiSelectSetting entities = new MultiSelectSetting.Builder()
            .name("modules.killaura.entities")
            .value("Players")
            .values("Players", "Monsters", "Invisibles", "Animals")
            .build();

    public final CheckBoxSetting smooth = new CheckBoxSetting.Builder()
            .name("Smooth")
            .value(false)
            .build();

    private final SliderSetting smoothSpeed = new SliderSetting.Builder()
            .name("modules.killaura.smoothspeed")
            .value(1.0)
            .min(0.1)
            .max(2.0)
            .increment(1)
            .build()
            .hide(() -> !smooth.getValue());

    private final SliderSetting noiseStrength = new SliderSetting.Builder()
            .name("Smoothing noise")
            .value(0.3)
            .min(0.0)
            .max(3.0)
            .increment(1)
            .build()
            .hide(() -> !smooth.getValue());

    public final CheckBoxSetting autoBlock = new CheckBoxSetting.Builder()
            .name("AutoBlock")
            .value(false)
            .build()
            .hide(() -> !attackMode.getValue().equalsIgnoreCase("Blatant"));

    public final StringSetting autoBlockMode = new StringSetting.Builder()
            .name("AutoBlock Mode")
            .value("Packet")
            .values("Packet", "Vanilla")
            .build()
            .hide(() -> !autoBlock.getValue() || !attackMode.getValue().equalsIgnoreCase("Blatant"));

    private final StringSetting rotationMode = new StringSetting.Builder()
            .name("Rotation mode")
            .value("Advanced")
            .values("Advanced", "Basic")
            .build();

    private final TimerUtil attackTimer = new TimerUtil();
    private final SecureRandom secureRandom = new SecureRandom();

    private final SmoothUtil smoothUtil = SmoothUtil.builder()
            .fractalOctaves(3)
            .frequency(0.1f)
            .fractalGain(0.65f)
            .smoothSpeed(smoothSpeed.floatValue())
            .noiseStrength(noiseStrength.floatValue())
            .build();

    private float currentCPS = 10.0f;
    private int rangeAddition;
    private boolean isBlocking = false;

    @Listen(priority = Priority.HIGHEST)
    private void onUpdate(UpdateEvent event) {
        if (mc.thePlayer.ticksExisted % 20 == 0) {
            rangeAddition = (int) (3 + Math.random() * 0.5);
        }

        getTargets();

        if (EntityUtil.getTargets().isEmpty()) {
            EntityUtil.setTarget(null);
            return;
        }

        EntityUtil.setTarget(EntityUtil.getTargets().getFirst());
    }

    @Listen(priority = Priority.HIGHEST)
    private void onLoop(GameLoopEvent e) {
        Vector2f rotation = new Vector2f(RotationUtil.getLastYaw(), RotationUtil.getLastPitch());
        MovingObjectPosition movingObjectPosition = RayCastUtil.rayCast(rotation, attackRange.getValue(), 0.5F, mc.thePlayer);

        if (movingObjectPosition != null && movingObjectPosition.typeOfHit == MovingObjectPosition.MovingObjectType.ENTITY) {
            if (EntityUtil.getTarget() == null || mc.thePlayer.getDistanceToEyes(EntityUtil.getTarget()) > attackRange.getValue()) {
                return;
            }

            if (attackTimer.hasTimeElapsed(1000 / currentCPS)) {
                if (attackMode.getValue().equalsIgnoreCase("Minecraft")) {
                    ClickUtils.action(ClickUtils.Button.LEFT, ClickUtils.Action.PRESS);
                } else {
                    handleAutoBlock(true);
                    mc.thePlayer.swingItem();
                    mc.playerController.attackEntity(mc.thePlayer, EntityUtil.getTarget());
                    handleAutoBlock(false);
                }

                HitEvent hitEvent = new HitEvent(EntityUtil.getTarget());
                hitEvent.post();

                attackTimer.reset();
                currentCPS = maxCPS.intValue() == minCPS.intValue() ? minCPS.intValue() : secureRandom.nextInt(minCPS.intValue(), maxCPS.intValue());
            } else {
                ClickUtils.action(ClickUtils.Button.LEFT, ClickUtils.Action.RELEASE);
            }
        }
    }

    private void handleAutoBlock(boolean blocking) {
        if (!autoBlock.getValue() || mc.thePlayer.getHeldItem() == null) {
            return;
        }

        if (blocking && !isBlocking) {
            if (autoBlockMode.getValue().equalsIgnoreCase("Packet")) {
                sendPacketNoEvent(new C02PacketUseEntity(EntityUtil.getTarget(), C02PacketUseEntity.Action.INTERACT));
                sendPacketNoEvent(new C08PacketPlayerBlockPlacement(mc.thePlayer.getHeldItem()));
            } else {
                mc.playerController.sendUseItem(mc.thePlayer, mc.theWorld, mc.thePlayer.getHeldItem());
            }
            isBlocking = true;
        } else if (!blocking && isBlocking) {
            if (autoBlockMode.getValue().equalsIgnoreCase("Packet")) {
                sendPacketNoEvent(new C07PacketPlayerDigging(C07PacketPlayerDigging.Action.RELEASE_USE_ITEM, BlockPos.ORIGIN, EnumFacing.DOWN));
            } else {
                mc.playerController.onStoppedUsingItem(mc.thePlayer);
            }
            isBlocking = false;
        }
    }

    @Listen
    private void onReach(ReachEvent event) {
        if (attackRange.getValue() >= 3.4) {
            event.setRange(attackRange.getValue() + 0.00256f);
            event.setBlockReachDistance(Math.max(mc.playerController.getBlockReachDistance(), attackRange.getValue() + 0.00256f));
        }
    }

    @Listen(priority = Priority.HIGHEST)
    private void onRots(RotationEvent event) {
        if (mc.thePlayer == null || mc.thePlayer.isDead || EntityUtil.getTarget() == null) {
            return;
        }

        float[] targetRotations = null;

        if (mc.thePlayer.getDistanceToEyes(EntityUtil.getTarget()) <= aimRange.getValue()) {
            targetRotations = switch (rotationMode.getValue()) {
                case "Advanced" -> RotationUtil.setRotation(EntityUtil.getTarget(), 0.08, true);
                case "Basic" -> RotationUtil.setRotation(EntityUtil.getTarget(), 0.03, false);
                default -> new float[] {mc.thePlayer.rotationYaw, mc.thePlayer.rotationPitch};
            };
        }

        if (targetRotations == null) {
            return;
        }

        float[] smoothedRotations = smooth.getValue() ?
                smoothUtil.smooth(targetRotations[0], targetRotations[1]) :
                targetRotations;

        event.setYaw(smoothedRotations[0]);
        event.setPitch(smoothedRotations[1]);
    }

    private void getTargets() {
        double range = attackRange.getValue();

        EntityUtil.setTargets(EntityUtil.Targets.get(range));

        if (EntityUtil.getTargets().isEmpty()) {
            EntityUtil.setTargets(EntityUtil.Targets.get(range + rangeAddition));
        }

        EntityUtil.getTargets().sort(EntityUtil.sortComparator());
    }

    @Override
    public void onEnable() {
        if (mc.thePlayer == null) {
            return;
        }

        ClickUtils.action(ClickUtils.Button.LEFT, ClickUtils.Action.RELEASE);

        if (nullCheck()) {
            smoothUtil.reset(mc.thePlayer.getRotationYaw(), mc.thePlayer.getRotationPitch());
        }
    }

    @Override
    public void onDisable() {
        if (mc.thePlayer == null) {
            return;
        }

        EntityUtil.setTarget(null);
        attackTimer.reset();

        ClickUtils.action(ClickUtils.Button.LEFT, ClickUtils.Action.RELEASE);

        if (isBlocking) {
            sendPacketNoEvent(new C07PacketPlayerDigging(C07PacketPlayerDigging.Action.RELEASE_USE_ITEM, BlockPos.ORIGIN, EnumFacing.DOWN));
            mc.playerController.onStoppedUsingItem(mc.thePlayer);
        }

        if (nullCheck()) {
            smoothUtil.reset(mc.thePlayer.getRotationYaw(), mc.thePlayer.getRotationPitch());
        }
    }

    @Override
    public String getSuffix() {
        return "" + attackRange.getValue();
    }
}