package tech.atani.client.module.impl.combat;

import net.minecraft.entity.EntityLivingBase;
import net.minecraft.network.EnumPacketDirection;
import net.minecraft.network.INetHandler;
import net.minecraft.network.Packet;
import net.minecraft.network.play.client.C02PacketUseEntity;
import net.minecraft.network.play.server.*;
import net.minecraft.util.Vec3;
import org.lwjgl.opengl.GL11;
import tech.atani.client.event.impl.PacketEvent;
import tech.atani.client.event.impl.Render3DEvent;
import tech.atani.client.event.impl.UpdateEvent;
import tech.atani.client.module.Module;
import tech.atani.client.module.data.Category;
import tech.atani.client.module.data.ModuleData;
import tech.atani.client.setting.impl.CheckBoxSetting;
import tech.atani.client.setting.impl.SliderSetting;
import tech.atani.client.util.client.events.base.Listen;
import tech.atani.client.util.game.entity.EntityUtil;
import tech.atani.client.util.game.network.PacketEntry;
import tech.atani.client.util.system.math.TimerUtil;

import java.util.concurrent.ConcurrentLinkedQueue;

@SuppressWarnings("unused")
@ModuleData(name = "BackTrack", category = Category.COMBAT, description = "modules.backtrack.description")
public class BackTrack extends Module {
    private final SliderSetting minRange = new SliderSetting.Builder()
            .name("modules.backtrack.minrange")
            .value(2)
            .min(0)
            .max(6)
            .build();

    private final SliderSetting maxRange = new SliderSetting.Builder()
            .name("modules.backtrack.maxrange")
            .value(4)
            .min(0)
            .max(10)
            .build();

    private final SliderSetting maxDelay = new SliderSetting.Builder()
            .name("modules.backtrack.maxdelay")
            .value(400)
            .min(40)
            .max(2000)
            .build();

    public final CheckBoxSetting onlyKillAura = new CheckBoxSetting.Builder()
            .name("modules.backtrack.onlyaura")
            .value(true)
            .build();

    private EntityLivingBase target;
    private INetHandler netHandler;
    private Vec3 spoofedPosition;
    private final TimerUtil timer = new TimerUtil();
    private final ConcurrentLinkedQueue<PacketEntry> packetBuffer = new ConcurrentLinkedQueue<>();
    private boolean spoofing;

    @Listen
    private void onUpdate(UpdateEvent event) {
        if (!nullCheck()) {
            releaseBuffer();
            spoofing = false;
            return;
        }

        target = EntityUtil.entity(!onlyKillAura.getValue());
        if (target == null || netHandler == null) {
            releaseBuffer();
            spoofing = false;
            return;
        }

        float distance = calculateDistance(target.posX, target.posY, target.posZ);
        spoofing = distance > minRange.getValue() && distance < maxRange.getValue() && !timer.hasTimeElapsed(maxDelay.getValue());

        if (!spoofing) {
            releaseBuffer();
            timer.reset();
            spoofedPosition = null;
        }
    }

    @Listen
    @SuppressWarnings("unchecked")
    private void onPacket(PacketEvent event) {
        if (!nullCheck() || target == null) return;

        netHandler = event.getINetHandler();
        Packet<?> packet = event.getPacket();

        if (event.getDirection() == EnumPacketDirection.CLIENTBOUND) {
            if (packet instanceof S08PacketPlayerPosLook) {
                releaseBuffer();
                spoofing = false;
                return;
            }

            if (packet instanceof S12PacketEntityVelocity velocityPacket) {
                if (velocityPacket.getEntityID() == mc.thePlayer.getEntityId()) {
                    releaseBuffer();
                    spoofing = false;
                    timer.reset();
                    spoofedPosition = null;
                    return;
                }
            }

            if (spoofing && shouldBufferPacket(packet)) {
                packetBuffer.add(new PacketEntry((Packet<INetHandler>) packet));
                event.setCancelled(true);

                if (packet instanceof S14PacketEntity p) {
                    var entity = p.getEntity(mc.theWorld);
                    if (entity == target) {
                        spoofedPosition = new Vec3(
                                target.posX + p.func_149062_c() / 32.0,
                                target.posY + p.func_149061_d() / 32.0,
                                target.posZ + p.func_149064_e() / 32.0
                        );
                    }
                } else if (packet instanceof S18PacketEntityTeleport p && p.getEntityId() == target.getEntityId()) {
                    spoofedPosition = new Vec3(p.getX() / 32.0, p.getY() / 32.0, p.getZ() / 32.0);
                }
            }
        } else if (event.getDirection() == EnumPacketDirection.SERVERBOUND && spoofing && packet instanceof C02PacketUseEntity useEntity) {
            if (useEntity.getEntityFromWorld(mc.theWorld) == target && spoofedPosition != null) {
                target.setPosition(spoofedPosition.xCoord, spoofedPosition.yCoord, spoofedPosition.zCoord);
            }
        }
    }

    @Listen
    private void onRender3D(Render3DEvent event) {
        if (target == null || !nullCheck() || !spoofing || spoofedPosition == null) return;

        double x = spoofedPosition.xCoord - mc.getRenderManager().renderPosX;
        double y = spoofedPosition.yCoord - mc.getRenderManager().renderPosY;
        double z = spoofedPosition.zCoord - mc.getRenderManager().renderPosZ;

        GL11.glPushMatrix();

        GL11.glDisable(GL11.GL_TEXTURE_2D);
        GL11.glDisable(GL11.GL_DEPTH_TEST);
        GL11.glEnable(GL11.GL_BLEND);
        GL11.glBlendFunc(GL11.GL_SRC_ALPHA, GL11.GL_ONE_MINUS_SRC_ALPHA);
        GL11.glLineWidth(2.0f);

        GL11.glColor4f(1.0f, 1.0f, 1.0f, 1.0f);

        GL11.glBegin(GL11.GL_LINE_LOOP);
        GL11.glVertex3d(x - 0.5, y, z - 0.5);
        GL11.glVertex3d(x + 0.5, y, z - 0.5);
        GL11.glVertex3d(x + 0.5, y, z + 0.5);
        GL11.glVertex3d(x - 0.5, y, z + 0.5);
        GL11.glEnd();

        GL11.glBegin(GL11.GL_LINE_LOOP);
        GL11.glVertex3d(x - 0.5, y + target.height, z - 0.5);
        GL11.glVertex3d(x + 0.5, y + target.height, z - 0.5);
        GL11.glVertex3d(x + 0.5, y + target.height, z + 0.5);
        GL11.glVertex3d(x - 0.5, y + target.height, z + 0.5);
        GL11.glEnd();

        GL11.glBegin(GL11.GL_LINES);
        GL11.glVertex3d(x - 0.5, y, z - 0.5);
        GL11.glVertex3d(x - 0.5, y + target.height, z - 0.5);
        GL11.glVertex3d(x + 0.5, y, z - 0.5);
        GL11.glVertex3d(x + 0.5, y + target.height, z - 0.5);
        GL11.glVertex3d(x + 0.5, y, z + 0.5);
        GL11.glVertex3d(x + 0.5, y + target.height, z + 0.5);
        GL11.glVertex3d(x - 0.5, y, z + 0.5);
        GL11.glVertex3d(x - 0.5, y + target.height, z + 0.5);
        GL11.glEnd();

        GL11.glDisable(GL11.GL_BLEND);
        GL11.glEnable(GL11.GL_DEPTH_TEST);
        GL11.glEnable(GL11.GL_TEXTURE_2D);
        GL11.glPopMatrix();
    }

    private float calculateDistance(double x, double y, double z) {
        Vec3 playerEyes = mc.thePlayer.getPositionEyes(mc.timer.renderPartialTicks);
        return (float) playerEyes.distanceTo(new Vec3(x, y, z));
    }

    private boolean shouldBufferPacket(Packet<?> packet) {
        return packet instanceof S14PacketEntity || packet instanceof S18PacketEntityTeleport;
    }

    private void releaseBuffer() {
        while (!packetBuffer.isEmpty() && netHandler != null) {
            PacketEntry entry = packetBuffer.poll();
            try {
                entry.getPacket().processPacket(netHandler);
            } catch (Exception ignored) {
            }
        }
        packetBuffer.clear();
    }

    @Override
    public void onEnable() {
        spoofing = false;
        spoofedPosition = null;
        packetBuffer.clear();
        timer.reset();
    }

    @Override
    public void onDisable() {
        releaseBuffer();
        if (target != null && nullCheck()) {
            target.setPosition(target.posX, target.posY, target.posZ);
        }
    }

    @Override
    public String getSuffix() {
        return maxDelay.stringValue();
    }
}