package tech.atani.client.module.impl.combat;

import net.minecraft.entity.projectile.EntityFireball;
import net.minecraft.util.MovingObjectPosition;
import org.lwjgl.util.vector.Vector2f;
import tech.atani.client.event.impl.GameLoopEvent;
import tech.atani.client.event.impl.ReachEvent;
import tech.atani.client.event.impl.RotationEvent;
import tech.atani.client.event.impl.UpdateEvent;
import tech.atani.client.module.Module;
import tech.atani.client.module.data.Category;
import tech.atani.client.module.data.ModuleData;
import tech.atani.client.setting.impl.SliderSetting;
import tech.atani.client.util.client.events.base.Listen;
import tech.atani.client.util.client.events.base.Priority;
import tech.atani.client.util.game.entity.RayCastUtil;
import tech.atani.client.util.game.player.ClickUtils;
import tech.atani.client.util.game.player.RotationUtil;
import tech.atani.client.util.system.math.TimerUtil;

import java.security.SecureRandom;
import java.util.Comparator;
import java.util.List;
import java.util.stream.Collectors;

@SuppressWarnings("unused")
@ModuleData(name = "AntiFireball", description = "modules.antifireball.description", category = Category.COMBAT)
public class AntiFireball extends Module {

    private final SliderSetting aimRange = new SliderSetting.Builder()
            .name("modules.antifireball.aimrange")
            .value(5)
            .min(1)
            .max(6)
            .increment(1)
            .build();

    private final SliderSetting swingRange = new SliderSetting.Builder()
            .name("modules.antifireball.swingrange")
            .value(3)
            .min(1)
            .max(6)
            .increment(1)
            .build();

    private float currentCPS = 10.0f;
    private int rangeAddition;
    private EntityFireball target;

    private final TimerUtil attackTimer = new TimerUtil();
    private final SecureRandom secureRandom = new SecureRandom();

    @Listen(priority = Priority.HIGHEST)
    private void onUpdate(UpdateEvent event) {
        if (mc.thePlayer.ticksExisted % 20 == 0) {
            rangeAddition = (int) (3 + Math.random() * 0.5);
        }

        List<EntityFireball> targets = getTargets(swingRange.doubleValue());

        if (targets.isEmpty()) {
            targets = getTargets(swingRange.doubleValue() + rangeAddition);
        }

        targets.sort(Comparator.comparingDouble(e -> e.getDistanceToEntity(mc.thePlayer)));

        if (targets.isEmpty()) {
            target = null;
            return;
        }

        target = targets.getFirst();
    }

    @Listen
    private void onReach(ReachEvent event) {
        if (swingRange.getValue() >= 3.4) {
            event.setRange(swingRange.getValue() + 0.00256f);
            event.setBlockReachDistance(Math.max(mc.playerController.getBlockReachDistance(), swingRange.getValue() + 0.00256f));
        }
    }

    @Listen(priority = Priority.HIGHEST)
    private void onRots(RotationEvent event) {
        if (mc.thePlayer == null || mc.thePlayer.isDead || target == null) {
            return;
        }

        if (mc.thePlayer.getDistanceToEyes(target) <= aimRange.floatValue()) {
            float[] targetRotations = RotationUtil.toRotation(mc.thePlayer.getPositionVector(), target.getPositionVector());

            event.setYaw(targetRotations[0]);
            event.setPitch(targetRotations[1]);
        }
    }

    @Listen(priority = Priority.HIGHEST)
    private void onLoop(GameLoopEvent e) {
        Vector2f rotation = new Vector2f(RotationUtil.getLastYaw(), RotationUtil.getLastPitch());
        MovingObjectPosition movingObjectPosition = RayCastUtil.rayCast(rotation, swingRange.getValue(), 0.5F, mc.thePlayer);

        if (movingObjectPosition != null && movingObjectPosition.typeOfHit == MovingObjectPosition.MovingObjectType.ENTITY) {
            if (target == null || mc.thePlayer.getDistanceToEyes(target) > swingRange.getValue()) {
                return;
            }

            if (attackTimer.hasTimeElapsed(1000 / currentCPS)) {
                ClickUtils.action(ClickUtils.Button.LEFT, ClickUtils.Action.PRESS);
                attackTimer.reset();

                currentCPS = secureRandom.nextInt(10, 11);
            } else {
                ClickUtils.action(ClickUtils.Button.LEFT, ClickUtils.Action.RELEASE);
            }
        }
    }

    @Override
    public void onDisable() {
        target = null;
    }

    @Override
    public String getSuffix() {
        return "" + swingRange.getValue();
    }

    private List<EntityFireball> getTargets() {
        return mc.theWorld.loadedEntityList.stream()
                .filter(entity -> entity instanceof EntityFireball)
                .map(entity -> (EntityFireball) entity)
                .collect(Collectors.toList());
    }

    private List<EntityFireball> getTargets(double range) {
        return getTargets().stream().filter(entity -> mc.thePlayer.getDistanceToEyes(entity) <= range).collect(Collectors.toList());
    }
}
