package tech.atani.client.module.impl.client;

import tech.atani.client.Atani;
import tech.atani.client.module.Module;
import tech.atani.client.module.data.Category;
import tech.atani.client.module.data.ModuleData;
import tech.atani.client.setting.impl.StringSetting;
import tech.atani.client.util.game.render.catppuccin.Mocha;

import java.awt.*;

@ModuleData(name = "Theme", description = "modules.theme.description", category = Category.CLIENT)
public class Theme extends Module {

    private final StringSetting theme = new StringSetting.Builder()
            .name("modules.theme.theme")
            .value("Green")
            .values("Green", "Sky", "Yellow", "Mauve", "Red", "Pink", "Flamingo")
            .build();

    public Theme() {
        setFrozen(true);
    }

    public static Color getMainColor() {
        switch (Atani.instance.moduleStorage.getT(Theme.class).theme.getValue()) {
            case "Sky" -> {
                return Mocha.SKY;
            }

            case "Yellow" -> {
                return Mocha.YELLOW;
            }

            case "Mauve" -> {
                return Mocha.MAUVE;
            }

            case "Red" -> {
                return Mocha.RED;
            }

            case "Pink" -> {
                return Mocha.PINK;
            }

            case "Flamingo" -> {
                return Mocha.FLAMINGO;
            }

            default -> {
                return Mocha.GREEN;
            }
        }
    }
}