package tech.atani.client.module.impl.client;

import net.minecraft.entity.Entity;
import tech.atani.client.event.impl.UpdateEvent;
import tech.atani.client.module.Module;
import tech.atani.client.module.data.Category;
import tech.atani.client.module.data.ModuleData;
import tech.atani.client.setting.impl.CheckBoxSetting;
import tech.atani.client.setting.impl.SliderSetting;
import tech.atani.client.util.client.events.base.Listen;

@SuppressWarnings("unused")
@ModuleData(name = "Performance", category = Category.CLIENT, description = "Optimizes performance.")
public class Performance extends Module {

    public final CheckBoxSetting entityCull = new CheckBoxSetting.Builder()
            .name("Entity Culling")
            .value(true)
            .build();

    private final SliderSetting cullDistance = new SliderSetting.Builder()
            .name("Culling Distance")
            .value(32)
            .min(1)
            .max(128)
            .build()
            .hide(() -> !entityCull.getValue());

    public final CheckBoxSetting chunkLimit = new CheckBoxSetting.Builder()
            .name("Chunk Limiting")
            .value(false)
            .build();

    @Listen
    private void onUpd(UpdateEvent event) {
        if (mc.thePlayer == null || mc.theWorld == null) {
            return;
        }

        if (entityCull.boolValue()) {
            for (Entity object : mc.theWorld.loadedEntityList) {
                if (object != null) {
                    if (object == mc.thePlayer) {
                        continue;
                    }

                    double distance = mc.thePlayer.getDistanceToEntity(object);
                    if (distance > cullDistance.floatValue() || !mc.thePlayer.canEntityBeSeen(object)) {
                        object.renderDistanceWeight = 0.0;
                    } else {
                        object.renderDistanceWeight = 1.0;
                    }
                }
            }
        }

        if (chunkLimit.boolValue()) {
            mc.theWorld.getChunkProvider().unloadQueuedChunks();
        }
    }

    @Override
    public void onDisable() {
        if (mc.theWorld != null) {
            for (Entity object : mc.theWorld.loadedEntityList) {
                if (object != null) {
                    object.renderDistanceWeight = 1.0;
                }
            }
        }
    }
}