package tech.atani.client.module.impl.client;

import tech.atani.client.Atani;
import tech.atani.client.module.Module;
import tech.atani.client.module.data.Category;
import tech.atani.client.module.data.ModuleData;
import tech.atani.client.setting.impl.StringSetting;

@ModuleData(name = "Language", description = "modules.language.description", category = Category.CLIENT)
public class Language extends Module {

    public final StringSetting lang = new StringSetting.Builder()
            .name("modules.language.language")
            .value("English")
            .values("English", "Latviešu", "Deutsch", "Suomi")
            .build();

    public Language() {
        setFrozen(true);
        lang.addListener((setting, oldValue, newValue) -> setLanguage());
    }

    public void setLanguage() {
        Atani.language = tech.atani.client.util.client.language.Language.getByName(lang.getValue());
    }

    public tech.atani.client.util.client.language.Language getLanguage() {
        return tech.atani.client.util.client.language.Language.getByName(this.lang.getValue());
    }
}