package tech.atani.client.module.impl.client;

import tech.atani.client.module.Module;
import tech.atani.client.module.data.Category;
import tech.atani.client.module.data.ModuleData;
import tech.atani.client.screen.clickGui.ClickGuiScreen;
import tech.atani.client.screen.clickGui.ModernClickGUI;
import tech.atani.client.setting.impl.StringSetting;

@ModuleData(name = "ClickGUI", description = "modules.clickgui.description", category = Category.CLIENT)
public class ClickGUI extends Module {

    private final StringSetting design = new StringSetting.Builder()
            .name("modules.clickgui.design")
            .value("Modern")
            .values("Modern", "Test")
            .build();

    public ClickGUI() {
        this.setKey(54);
    }

    private ModernClickGUI modernClickGUI;
    private ClickGuiScreen testGui;

    @Override
    public void onEnable() {
        super.onEnable();

        switch (design.getValue()) {
            case "Modern" -> {
                if (modernClickGUI == null) {
                    modernClickGUI = new ModernClickGUI();
                }
                mc.displayGuiScreen(modernClickGUI);
            }
            case "Test" -> {
                if (testGui == null) {
                    testGui = new ClickGuiScreen();
                }
                mc.displayGuiScreen(testGui);
            }
        }
        toggle();
    }
}
