package tech.atani.client.module.impl.client;

import net.minecraft.util.ResourceLocation;
import tech.atani.client.event.impl.RenderCapeEvent;
import tech.atani.client.event.impl.GetCapeLocationEvent;
import tech.atani.client.event.impl.UpdateEventPlayer;
import tech.atani.client.module.Module;
import tech.atani.client.module.data.Category;
import tech.atani.client.module.data.ModuleData;
import tech.atani.client.setting.impl.SliderSetting;
import tech.atani.client.setting.impl.StringSetting;
import tech.atani.client.util.client.events.base.Listen;

@ModuleData(name = "Cape", description = "modules.cape.description", category = Category.CLIENT)
public class Cape extends Module {
    private final StringSetting design = new StringSetting.Builder()
            .name("modules.cape.design")
            .value("Modern 1")
            .values("Modern 1", "Modern 2", "Logo", "Simple")
            .build();

    public final StringSetting windMode = new StringSetting.Builder()
            .name("modules.cape.windmode")
            .value("None")
            .values("None", "Waves", "Slight")
            .build();

    public final StringSetting capeStyle = new StringSetting.Builder()
            .name("modules.cape.capestyle")
            .value("Smooth")
            .values("Blocky", "Smooth")
            .build();

    public final SliderSetting gravity = new SliderSetting.Builder()
            .name("modules.cape.gravity")
            .value(20)
            .min(0)
            .max(50)
            .build();

    public final SliderSetting heightMultiplier = new SliderSetting.Builder()
            .name("modules.cape.heightmultiplier")
            .value(6)
            .min(0)
            .max(12)
            .build();

    public final SliderSetting maxBend = new SliderSetting.Builder()
            .name("modules.cape.maxbend")
            .value(5)
            .min(0)
            .max(10)
            .build();

    @Listen
    private void onCape(GetCapeLocationEvent event) {
        if (event.player == mc.thePlayer) {
            event.cape = new ResourceLocation("atani", "images/" + design.getValue() + ".png");
        }
    }

    @Listen
    private void onRenderCape(RenderCapeEvent event) {
        event.cancelled = true;
    }

    @Listen
    private void onUpdateEventPlayer(UpdateEventPlayer event) {
        event.getEntityPlayer().simulate(event.getEntityPlayer());
    }
}