package tech.atani.client.file.impl;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import tech.atani.client.Atani;
import tech.atani.client.file.File;
import tech.atani.client.module.Module;
import tech.atani.client.util.system.files.FileUtil;

public class KeybindFile extends File {
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();

    public KeybindFile() {
        super("keybinds", FileUtil.getRunningPath() + "/keybinds.ata");
    }

    @Override
    protected String getData() {
        JsonObject configObject = new JsonObject();
        Atani.instance.moduleStorage.getSet().forEach(module -> {
            JsonObject moduleObject = new JsonObject();
            moduleObject.addProperty("Key", module.getKey());
            configObject.add(module.getData().name(), moduleObject);
        });
        return GSON.toJson(configObject);
    }

    @Override
    protected void loadData(String data) {
        if (data.isBlank()) {
            data = "{}";
        }

        JsonObject configObject = JsonParser.parseString(data).getAsJsonObject();
        configObject.entrySet().forEach(entry -> {
            String moduleName = entry.getKey();
            int key = entry.getValue().getAsJsonObject().get("Key").getAsInt();
            Module module = Atani.instance.moduleStorage.getModule(moduleName);
            if (module != null) {
                module.setKey(key);
            }
        });
    }
}