package tech.atani.client.file.impl;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import tech.atani.client.Atani;
import tech.atani.client.file.File;
import tech.atani.client.screen.altManager.Account;
import tech.atani.client.screen.altManager.EnumAccountType;
import tech.atani.client.util.system.files.FileUtil;

public class AccountFile extends File {
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();

    public AccountFile() {
        super("accounts", FileUtil.getRunningPath() + "/accounts.ata");
    }

    @Override
    protected String getData() {
        JsonObject configObject = new JsonObject();
        Atani.instance.accountStorage.getSet().forEach(account -> {
            JsonObject accountObject = new JsonObject();
            accountObject.addProperty("Password", account.getPassword());
            accountObject.addProperty("Token", account.getToken());
            accountObject.addProperty("Skin", account.getSkin());
            accountObject.addProperty("Type", account.getType().name());
            configObject.add(account.getName(), accountObject);
        });
        return GSON.toJson(configObject);
    }

    @Override
    protected void loadData(String data) {
        if (data.isBlank()) {
            data = "{}";
        }

        JsonObject configObject = JsonParser.parseString(data).getAsJsonObject();
        configObject.entrySet().forEach(entry -> {
            String accountName = entry.getKey();
            JsonObject accountObject = entry.getValue().getAsJsonObject();
            EnumAccountType type = EnumAccountType.valueOf(accountObject.get("Type").getAsString());
            Account account = new Account(type, accountName);
            account.setPassword(accountObject.get("Password").getAsString());
            account.setToken(accountObject.get("Token").getAsString());
            account.setSkin(accountObject.get("Skin").getAsString());
            Atani.instance.accountStorage.add(account);
        });
    }
}