package tech.atani.client.file;

import tech.atani.client.util.client.interfaces.IClient;
import tech.atani.client.util.client.interfaces.ILogger;
import tech.atani.client.util.system.EncryptUtil;
import tech.atani.client.util.system.files.FileUtil;

import java.nio.file.Path;

public abstract class File implements IClient {
    protected final String name;
    protected final String path;

    protected File(String name, String path) {
        this.name = name.endsWith(".ata") ? name : name + ".ata";
        this.path = path;
    }

    protected File(String name) {
        this(name, FileUtil.getRunningPath() + "/" + name);
    }

    public void save() {
        try {
            String data = getData();
            if (data != null) {
                String encryptedData = EncryptUtil.encrypt(data);
                if (encryptedData != null) {
                    FileUtil.write(Path.of(path), encryptedData);
                    ILogger.logger.info("Successfully saved {}!", name);
                }
            }
        } catch (Exception e) {
            ILogger.logger.error("Failed to save {}!", name, e);
        }
    }

    public void load() {
        try {
            String content = FileUtil.read(Path.of(path));
            String decryptedData = EncryptUtil.decrypt(content);

            loadData(decryptedData);
            ILogger.logger.info("Successfully loaded {}!", name);
        } catch (Exception e) {
            ILogger.logger.error("Failed to load {}!", name, e);
        }
    }

    protected abstract String getData();
    protected abstract void loadData(String data);
}