package tech.atani.client.command.impl;

import net.minecraft.util.EnumChatFormatting;
import tech.atani.client.Atani;
import tech.atani.client.command.Command;
import tech.atani.client.command.data.CommandData;
import tech.atani.client.module.Module;
import tech.atani.client.module.data.Category;
import tech.atani.client.util.client.language.TranslationUtil;
import tech.atani.client.util.system.files.FileUtil;

import java.io.File;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

@CommandData(aliases = {"script", "scripts"}, description = "commands.script.description")
public class ScriptCommand extends Command {
    @Override
    public void onCommand(String[] args) {
        if (args.length == 0) {
            info(TranslationUtil.getTranslation("commands.script.badarguments"));
            return;
        }

        String subCommand = args[0].toLowerCase();
        switch (subCommand) {
            case "list" -> {
                File scriptFolder = new File(FileUtil.getRunningPath() + "/scripts");
                Set<Module> scriptModules = Atani.instance.moduleStorage.getModulesByCategory(Category.SCRIPT);

                if (!scriptFolder.exists() || !scriptFolder.isDirectory() || scriptModules.isEmpty()) {
                    info(TranslationUtil.getTranslation("commands.script.noscriptsfound"));
                    return;
                }

                Set<String> loadedScriptNames = new HashSet<>(scriptModules.size());
                for (Module module : scriptModules) {
                    loadedScriptNames.add(module.getData().name() + ".lua");
                }

                info(TranslationUtil.getTranslation("commands.script.listavailable"));
                File[] files = scriptFolder.listFiles();
                if (files != null) {
                    for (File file : files) {
                        String fileName = file.getName();
                        boolean loaded = loadedScriptNames.contains(fileName);
                        info(EnumChatFormatting.YELLOW + fileName + EnumChatFormatting.RESET + (loaded ? " (loaded)" : ""), false);
                    }
                }
            }
            case "reload" -> new Thread(() -> {
                Set<Module> scriptModules = Atani.instance.moduleStorage.getModulesByCategory(Category.SCRIPT);
                Map<String, Integer> savedKeybinds = new HashMap<>(scriptModules.size());

                for (Module module : scriptModules) {
                    savedKeybinds.put(module.getName(), module.getKey());
                }

                Atani.instance.moduleStorage.getSet().removeAll(scriptModules);
                Atani.instance.moduleStorage.scriptAPI.loadScripts();

                for (Module module : Atani.instance.moduleStorage.getModulesByCategory(Category.SCRIPT)) {
                    module.setKey(savedKeybinds.getOrDefault(module.getName(), 0));
                }

                info(TranslationUtil.getTranslation("commands.script.reloaded"));
            }).start();
        }
    }
}