package tech.atani.client.command.impl;

import net.minecraft.util.EnumChatFormatting;
import tech.atani.client.Atani;
import tech.atani.client.command.Command;
import tech.atani.client.command.data.CommandData;
import tech.atani.client.util.client.language.TranslationUtil;

@CommandData(aliases = {"help"}, description = "commands.help.description")
public class HelpCommand extends Command {
    @Override
    public void onCommand(String[] args) {
        info(TranslationUtil.getTranslation("commands.help.list"));
        Atani.instance.commandStorage.getSet().forEach(command ->
                info(EnumChatFormatting.YELLOW + Atani.instance.commandStorage.prefix +
                                command.getData().aliases()[0] + EnumChatFormatting.GRAY + " - " +
                                EnumChatFormatting.WHITE + TranslationUtil.getTranslation(command.getData().description()), false)
        );
    }
}