package tech.atani.client.command.impl;

import net.minecraft.util.EnumChatFormatting;
import tech.atani.client.Atani;
import tech.atani.client.command.Command;
import tech.atani.client.command.data.CommandData;
import tech.atani.client.file.impl.KeybindFile;
import tech.atani.client.file.impl.ModuleFile;
import tech.atani.client.util.client.language.TranslationUtil;

@CommandData(aliases = {"config", "cfg"}, description = "commands.config.description")
public class ConfigCommand extends Command {
    @Override
    public void onCommand(String[] args) {
        if (args.length > 1) {
            String subCommand = args[0].toLowerCase();
            String configName = args[1];

            switch (subCommand) {
                case "save" -> {
                    Atani.instance.fileStorage.getT(KeybindFile.class).save();
                    ModuleFile moduleFile = new ModuleFile(configName);
                    moduleFile.save();

                    info(String.format(TranslationUtil.getTranslation("commands.config.saved"), configName));
                }
                case "load" -> {
                    ModuleFile moduleFile = new ModuleFile(configName);
                    moduleFile.load();

                    info(String.format(TranslationUtil.getTranslation("commands.config.loaded"), configName));
                }
            }
        } else {
            info(TranslationUtil.getTranslation("commands.config.badarguments"));
        }
    }
}