package tech.atani.client.command.impl;

import org.lwjgl.input.Keyboard;
import tech.atani.client.Atani;
import tech.atani.client.command.Command;
import tech.atani.client.command.data.CommandData;
import tech.atani.client.module.Module;
import tech.atani.client.util.client.language.TranslationUtil;

@CommandData(aliases = {"bind"}, description = "commands.bind.description")
public class BindCommand extends Command {
    @Override
    public void onCommand(String[] args) {
        if (args.length < 2) {
            info(TranslationUtil.getTranslation("commands.bind.badarguments"));
            return;
        }

        String moduleName = args[0];
        String key = args[1].toUpperCase();
        int keyCode = Keyboard.getKeyIndex(key);
        Module module = Atani.instance.moduleStorage.getModule(moduleName);

        if (module == null) {
            info(String.format(TranslationUtil.getTranslation("commands.bind.modulenotfound"), moduleName));
            return;
        }

        module.setKey(keyCode);
        String formattedKey = Keyboard.getKeyName(keyCode);
        info(String.format(TranslationUtil.getTranslation("commands.bind.success"), module.getData().name(), formattedKey));
    }
}