package tech.atani.client.command;

import lombok.Getter;
import tech.atani.client.command.data.CommandData;
import tech.atani.client.util.client.interfaces.IMinecraft;

import java.util.Arrays;

@Getter
public abstract class Command implements IMinecraft {
    private final CommandData data = getClass().getAnnotation(CommandData.class);

    public abstract void onCommand(String[] args);

    public boolean isAlias(String alias) {
        return Arrays.asList(data.aliases()).contains(alias);
    }
}
