package tech.atani.client.authentication.request.impl;

import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import org.apache.http.client.HttpClient;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.impl.conn.PoolingHttpClientConnectionManager;
import tech.atani.client.authentication.request.Request;
import tech.atani.client.authentication.request.data.RequestException;
import tech.atani.client.util.system.files.FileUtil;

import java.nio.charset.StandardCharsets;
import java.nio.file.Paths;

public class ScriptsRequest extends Request {
    private static final HttpClient HTTP_CLIENT;

    static {
        var cm = new PoolingHttpClientConnectionManager();
        cm.setMaxTotal(100);
        cm.setDefaultMaxPerRoute(20);
        HTTP_CLIENT = HttpClients.custom().setConnectionManager(cm).build();
    }

    public void request(String args) {
        if (args == null || !args.contains("list")) return;

        var get = new HttpGet(LIST_SCRIPTS_URL);
        try {
            var response = HTTP_CLIENT.execute(get);
            var entity = response.getEntity();
            if (entity == null) return;
            try (var inputStream = entity.getContent()) {
                var content = new String(inputStream.readAllBytes(), StandardCharsets.UTF_8);
                var object = JsonParser.parseString(content).getAsJsonObject();
                if (!object.has("files")) return;

                var filesArray = object.getAsJsonArray("files");
                for (var element : filesArray) {
                    var fileName = element.getAsString().endsWith(".lua")
                            ? element.getAsString()
                            : element.getAsString() + ".lua";
                    var script = getScript(fileName);
                    if (script.has("content")) {
                        FileUtil.write(
                                Paths.get(FileUtil.getRunningPath().toString(), "scripts", fileName),
                                script.get("content").getAsString()
                        );
                    }
                }
            }
        } catch (Exception e) {
            throw new RequestException("Failed to process scripts list request: " + e.getMessage());
        } finally {
            get.releaseConnection();
        }
    }

    private JsonObject getScript(String name) {
        var scriptUrl = GET_SCRIPTS_URL + (name.endsWith(".lua") ? name : name + ".lua");
        var get = new HttpGet(scriptUrl);
        try {
            var response = HTTP_CLIENT.execute(get);
            var entity = response.getEntity();
            if (entity == null) return new JsonObject();
            try (var inputStream = entity.getContent()) {
                return JsonParser.parseString(
                        new String(inputStream.readAllBytes(), StandardCharsets.UTF_8)
                ).getAsJsonObject();
            }
        } catch (Exception e) {
            throw new RequestException("Failed to fetch script '" + name + "': " + e.getMessage());
        } finally {
            get.releaseConnection();
        }
    }
}