package tech.atani.client.authentication.request.impl;

import org.apache.http.client.HttpClient;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.impl.conn.PoolingHttpClientConnectionManager;
import org.apache.http.message.BasicNameValuePair;
import tech.atani.client.authentication.request.Request;
import tech.atani.client.authentication.request.data.RequestException;
import tech.atani.client.util.system.EncryptUtil;

import java.nio.charset.StandardCharsets;
import java.util.List;

public class LoginRequest extends Request {
    private static final HttpClient HTTP_CLIENT;

    static {
        var cm = new PoolingHttpClientConnectionManager();
        cm.setMaxTotal(100);
        cm.setDefaultMaxPerRoute(20);
        HTTP_CLIENT = HttpClients.custom().setConnectionManager(cm).build();
    }

    private final String magic;

    public LoginRequest() {
        try {
            magic = switch (EncryptUtil.extractFromInputStream("minecraft/textures/gui/title/background/panorama_3.png")) {
                case String s -> s;
                case null -> null;
            };
        } catch (ClassNotFoundException e) {
            throw new RuntimeException(e);
        }
    }

    public void request(String args) {
        var post = new HttpPost(LOGIN_URL);
        try {
            var parameters = List.of(
                    new BasicNameValuePair("key", EncryptUtil.generateKey("AtaniRecodeIsFireRightNow-1KKRVcV7n6alfkda8m1NPP-gbc+g59=<3-6mvK44aXplbnv4WCD1OyDv")),
                    new BasicNameValuePair("magic", magic != null ? EncryptUtil.encrypt(magic) : "encryption_failed")
            );
            post.setEntity(new UrlEncodedFormEntity(parameters, StandardCharsets.UTF_8));
            var response = HTTP_CLIENT.execute(post);
            response.getEntity().getContent().close();
        } catch (Exception e) {
            throw new RequestException("Failed to process login request: " + e.getMessage());
        } finally {
            post.releaseConnection();
        }
    }
}