package tech.atani.client.authentication.request.impl;

import com.google.gson.JsonParser;
import org.apache.http.client.HttpClient;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.impl.conn.PoolingHttpClientConnectionManager;
import org.apache.http.message.BasicNameValuePair;
import tech.atani.client.authentication.request.Request;
import tech.atani.client.authentication.request.data.RequestException;
import tech.atani.client.util.system.HWIDUtil;
import tech.atani.client.util.system.EncryptUtil;

import java.nio.charset.StandardCharsets;
import java.util.List;

public class CrashReportRequest extends Request {
    private static final HttpClient HTTP_CLIENT;

    static {
        var cm = new PoolingHttpClientConnectionManager();
        cm.setMaxTotal(100);
        cm.setDefaultMaxPerRoute(20);
        HTTP_CLIENT = HttpClients.custom().setConnectionManager(cm).build();
    }

    public void request(String[] args) {
        if (args == null || args.length == 0) return;

        var post = new HttpPost(CRASH_REPORT_URL);
        try {
            var parameters = List.of(
                    new BasicNameValuePair("key", EncryptUtil.generateKey("AtaniRecodeIsFireRightNow-1KKRVcV7n6alfkda8m1NPP-gbc+g59=<3-6mvK44aXplbnv4WCD1OyDv")),
                    new BasicNameValuePair("computer", HWIDUtil.getComputerName()),
                    new BasicNameValuePair("cpu", HWIDUtil.getCPU()),
                    new BasicNameValuePair("gpu", HWIDUtil.getGPU()),
                    new BasicNameValuePair("ram", HWIDUtil.getMaxRAM()),
                    new BasicNameValuePair("report", String.join("\n", args))
            );
            post.setEntity(new UrlEncodedFormEntity(parameters, StandardCharsets.UTF_8));

            var response = HTTP_CLIENT.execute(post);
            var entity = response.getEntity();
            if (entity != null) {
                try (var inputStream = entity.getContent()) {
                    var content = new String(inputStream.readAllBytes(), StandardCharsets.UTF_8);
                    var json = JsonParser.parseString(content).getAsJsonObject();
                    if (!json.has("success")) return;
                }
            }
        } catch (Exception e) {
            throw new RequestException("Failed to process crash report request: " + e.getMessage());
        } finally {
            post.releaseConnection();
        }
    }
}