package tech.atani.client;

import de.florianmichael.viamcp.ViaMCP;
import tech.atani.client.authentication.Connector;
import tech.atani.client.file.impl.AccountFile;
import tech.atani.client.file.impl.KeybindFile;
import tech.atani.client.file.impl.ModuleFile;
import tech.atani.client.storage.impl.*;
import tech.atani.client.util.client.interfaces.IClient;
import tech.atani.client.util.client.interfaces.ILogger;
import tech.atani.client.util.client.language.Language;
import tech.atani.client.util.client.language.TranslationUtil;
import tech.atani.client.util.system.files.FileUtil;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;

public class Atani implements IClient, ILogger {
    public final static Atani instance = new Atani();
    public static Language language = TranslationUtil.getCountryFromLocale();

    public Atani() {
        try {
            Files.createDirectories(FileUtil.getRunningPath());
            Files.createDirectories(Path.of(FileUtil.getRunningPath().toString(), "configs"));
            Files.createDirectories(Path.of(FileUtil.getRunningPath().toString(), "scripts"));
        } catch (IOException e) {
            ILogger.logger.error("Failed to create atani folders!");
        }
    }

    public final ModuleStorage moduleStorage = new ModuleStorage();
    public final FontStorage fontStorage = new FontStorage();
    public final ShaderStorage shaderStorage = new ShaderStorage();
    public final CommandStorage commandStorage = new CommandStorage();
    public final FileStorage fileStorage = new FileStorage();
    public final AccountStorage accountStorage = new AccountStorage();
    public final TranslationStorage translationStorage = new TranslationStorage();

    public final long startingTime = System.currentTimeMillis();

    public void preStart() {
        logger.info("Pre-starting Atani!");

        shaderStorage.init();
        fontStorage.init();
        fileStorage.init();

        logger.info("Atani pre-started in {} seconds", (System.currentTimeMillis() - startingTime) / 1000.0d);
    }

    public void start() {
        logger.info("Starting Atani!");

        Connector.instance.start();

        moduleStorage.init();
        commandStorage.init();
        accountStorage.init();

        ViaMCP.create();
        ViaMCP.INSTANCE.initAsyncSlider();

        logger.info("Atani started in {} seconds", (System.currentTimeMillis() - startingTime) / 1000.0d);

        fileStorage.getT(ModuleFile.class).load();
        fileStorage.getT(KeybindFile.class).load();
        fileStorage.getT(AccountFile.class).load();

        fileStorage.config = FileUtil.loadFileToJson("client.json");

        translationStorage.init();

        Runtime.getRuntime().addShutdownHook(new Thread(Atani.instance::stop));
    }

    public void stop() {
        logger.info("Stopping Atani!");

        fileStorage.getT(ModuleFile.class).save();
        fileStorage.getT(KeybindFile.class).save();
        fileStorage.getT(AccountFile.class).save();

        FileUtil.saveJsonToFile(fileStorage.config, "client.json");
    }
}
