package org.lwjgl.openal;

public class Source {
    private final int sourceId;

    public Source(int bufferId) {
        sourceId = AL10.alGenSources();
        AL10.alSourcei(sourceId, AL10.AL_BUFFER, bufferId);
    }

    public boolean playing() {
        return AL10.alGetSourcei(sourceId, AL10.AL_SOURCE_STATE) == AL10.AL_PLAYING;
    }

    public boolean paused() {
        return AL10.alGetSourcei(sourceId, AL10.AL_SOURCE_STATE) == AL10.AL_PAUSED;
    }

    public boolean preLoad() {
        return AL10.alGetSourcei(sourceId, AL10.AL_SOURCE_STATE) == AL10.AL_INITIAL;
    }

    public void play() {
        AL10.alSourcePlay(sourceId);
    }

    public void stop() {
        AL10.alSourceStop(sourceId);
    }

    public void pause() {
        AL10.alSourcePause(sourceId);
    }

    public void cleanup() {
        AL10.alDeleteSources(sourceId);
    }

    public int getSourceId() {
        return sourceId;
    }
}