package net.minecraft.util;

import net.minecraft.client.settings.GameSettings;
import tech.atani.client.Atani;
import tech.atani.client.event.impl.MoveButtonEvent;
import tech.atani.client.event.impl.MoveInputEvent;

public class MovementInputFromOptions extends MovementInput {
    private final GameSettings gameSettings;

    public MovementInputFromOptions(GameSettings gameSettingsIn) {
        this.gameSettings = gameSettingsIn;
    }

    public void updatePlayerMoveState() {
        this.moveStrafe = 0.0F;
        this.moveForward = 0.0F;

        MoveButtonEvent moveButtonEvent = new MoveButtonEvent(
                this.gameSettings.keyBindForward.isKeyDown(),
                this.gameSettings.keyBindBack.isKeyDown(),
                this.gameSettings.keyBindLeft.isKeyDown(),
                this.gameSettings.keyBindRight.isKeyDown(),
                this.gameSettings.keyBindJump.isKeyDown(),
                this.gameSettings.keyBindSneak.isKeyDown()
        );
        moveButtonEvent.post();

        if (moveButtonEvent.isForward()) {
            ++this.moveForward;
        }

        if (moveButtonEvent.isBack()) {
            --this.moveForward;
        }

        if (moveButtonEvent.isLeft()) {
            ++this.moveStrafe;
        }

        if (moveButtonEvent.isRight()) {
            --this.moveStrafe;
        }

        this.jump = moveButtonEvent.isJump();
        this.sneak = moveButtonEvent.isSneak();

        MoveInputEvent moveInputEvent = new MoveInputEvent(this.moveForward, this.moveStrafe, this.jump, this.sneak, 0.3F);
        moveInputEvent.post();

        this.moveStrafe = moveInputEvent.getStrafe();
        this.moveForward = moveInputEvent.getForward();

        this.jump = moveInputEvent.isJumping();
        this.sneak = moveInputEvent.isSneaking();

        if (this.sneak) {
            this.moveStrafe *= moveInputEvent.getSneakFactor();
            this.moveForward *= moveInputEvent.getSneakFactor();
        }
    }
}
