package net.minecraft.client.renderer;

import java.nio.ByteBuffer;
import net.optifine.SmartAnimations;

public class Tessellator {
    private final WorldRenderer worldRenderer;
    private final WorldVertexBufferUploader vboUploader = new WorldVertexBufferUploader();
    private static final Tessellator instance = new Tessellator(2097152);
    private ByteBuffer sharedBuffer;
    private int bufferCapacity;

    public static Tessellator getInstance() {
        return instance;
    }

    public Tessellator(int bufferSize) {
        this.bufferCapacity = bufferSize;
        this.sharedBuffer = GLAllocation.createDirectByteBuffer(bufferSize);
        this.worldRenderer = new WorldRenderer(bufferSize);
    }

    public void draw() {
        var sprites = worldRenderer.animatedSprites;
        if (sprites != null) {
            SmartAnimations.spritesRendered(sprites);
        }

        worldRenderer.finishDrawing();
        var vertexCount = worldRenderer.getVertexCount();
        if (vertexCount == 0) return;

        var required = vertexCount * worldRenderer.getVertexFormat().getNextOffset();
        ensureCapacity(required);

        sharedBuffer.clear();
        sharedBuffer.put(worldRenderer.getByteBuffer());
        sharedBuffer.flip();

        vboUploader.draw(worldRenderer);
    }

    public WorldRenderer getWorldRenderer() {
        return worldRenderer;
    }

    private void ensureCapacity(int required) {
        if (required > bufferCapacity) {
            bufferCapacity = Math.max(required, bufferCapacity << 1);
            var newBuffer = GLAllocation.createDirectByteBuffer(bufferCapacity);
            sharedBuffer.flip();
            newBuffer.put(sharedBuffer);
            sharedBuffer = newBuffer;
        }
    }
}