package net.minecraft.client.gui;

import net.minecraft.client.Minecraft;
import net.minecraft.client.audio.PositionedSoundRecord;
import net.minecraft.client.audio.SoundHandler;
import net.minecraft.util.ResourceLocation;
import tech.atani.client.Atani;
import tech.atani.client.util.game.render.animation.Animation;
import tech.atani.client.util.game.render.animation.EnumTransition;
import tech.atani.client.util.game.render.catppuccin.Mocha;
import tech.atani.client.util.game.render.font.gui.font.renderer.SimpleFontRenderer;
import tech.atani.client.util.game.render.shader.data.renderer.Renderer;

import java.util.Locale;

public class GuiButton extends Gui
{
    protected static final ResourceLocation buttonTextures = new ResourceLocation("textures/gui/widgets.png");
    private final SimpleFontRenderer font = Atani.instance.fontStorage.getFont("Inter-Bold", 14).newRenderer();
    private final Animation anim = new Animation(0.f, EnumTransition.SQRT, 2.f);
    protected int width;
    protected int height;
    public int xPosition;
    public int yPosition;
    public String displayString;
    public int id;
    public boolean enabled;
    public boolean visible;
    protected boolean hovered;

    public GuiButton(int buttonId, int x, int y, String buttonText)
    {
        this(buttonId, x, y, 200, 20, buttonText);
    }

    public GuiButton(int buttonId, int x, int y, int widthIn, int heightIn, String buttonText)
    {
        this.enabled = true;
        this.visible = true;
        this.id = buttonId;
        this.xPosition = x;
        this.yPosition = y;
        this.width = widthIn;
        this.height = heightIn;
        this.displayString = buttonText;
    }

    protected int getHoverState(boolean mouseOver)
    {
        int i = 1;

        if (!this.enabled)
        {
            i = 0;
        }
        else if (mouseOver)
        {
            i = 2;
        }

        return i;
    }

    public void drawButton(Minecraft mc, int mouseX, int mouseY)
    {
        if (this.visible)
        {
            this.hovered = mouseX >= this.xPosition && mouseY >= this.yPosition && mouseX < this.xPosition + this.width && mouseY < this.yPosition + this.height;

            this.mouseDragged(mc, mouseX, mouseY);

            anim.update(hovered ? 100 : 0);

            Renderer.drawRectangle(this.xPosition, this.yPosition, this.width * (anim.getValue() / 100), this.height, Mocha.SURFACE_0);

            font.drawXYCenteredString(this.displayString.toLowerCase(Locale.ROOT), (float) (this.xPosition + this.width / 2), (float) (this.yPosition + (this.height / 2)), Mocha.TEXT);
        }
    }

    protected void mouseDragged(Minecraft mc, int mouseX, int mouseY)
    {
    }

    public void mouseReleased(int mouseX, int mouseY)
    {
    }

    public boolean mousePressed(Minecraft mc, int mouseX, int mouseY)
    {
        return this.enabled && this.visible && mouseX >= this.xPosition && mouseY >= this.yPosition && mouseX < this.xPosition + this.width && mouseY < this.yPosition + this.height;
    }

    public boolean isMouseOver()
    {
        return this.hovered;
    }

    public void drawButtonForegroundLayer(int mouseX, int mouseY)
    {
    }

    public void playPressSound(SoundHandler soundHandlerIn)
    {
        soundHandlerIn.playSound(PositionedSoundRecord.create(new ResourceLocation("gui.button.press"), 1.0F));
    }

    public int getButtonWidth()
    {
        return this.width;
    }

    public void setWidth(int width)
    {
        this.width = width;
    }
}
