package net.optifine.shaders.shaderoption

import net.bloom.bloomclient.value.values.shaders.ShaderBoolValue
import net.optifine.expr.IExpressionResolver
import net.optifine.shaders.file.AbstractShaderPack

class ShaderResolver(val shaderPack: AbstractShaderPack): IExpressionResolver {

    val options = hashMapOf<String, ExpressShaderBoolValue>()

    init {
        shaderPack.options.shaderValues.filterIsInstance<ShaderBoolValue>().forEach {
            options[it.name] = ExpressShaderBoolValue(it)
        }
    }

    override fun getExpression(name: String?) = options[name]

}