package net.optifine.shaders.shaderoption

open class ShaderProfile(val name: String) {

    val options = hashMapOf<String, String>()
    val disabledPrograms = mutableSetOf<String>()

    fun addOption(option: String, value: Any) {
        options[option] = value.toString()
    }

    fun addOptionsFromProfile(profile: ShaderProfile?) {
        profile ?: return
        options.putAll(profile.options)
    }

    fun addDisabledProgramsFromProfile(profile: ShaderProfile?) {
        profile ?: return
        disabledPrograms.addAll(profile.disabledPrograms)
    }

    fun isProgramDisabled(program: String) = program in disabledPrograms
}