package net.optifine.shaders.shaderoption

import net.bloom.bloomclient.file.Configurable
import net.bloom.bloomclient.utils.render.ScrollUtils
import net.bloom.bloomclient.value.Value
import net.bloom.bloomclient.value.values.GroupValue
import net.minecraft.client.gui.options.value.AbstractOptionValueComponent
import net.minecraft.client.option.OptionManager
import net.optifine.shaders.file.AbstractShaderPack

class ShaderOption: Configurable() {

    val clouds = list("clouds", "options.default", arrayOf("options.default", "options.fancy", "options.fast"))
    private val oldLightingObject = bool("oldLighting", false)
    val oldLighting by oldLightingObject

    private val oldHandlightObject = bool("oldHandLight", false)
    val oldHandlight by oldHandlightObject

    private val dynamicHandlightObject = bool("dynamicHandLight", false)
    val dynamicHandlight by dynamicHandlightObject
    private val shadowTranslucentObject = bool("shadowTranslucent", false)
    val shadowTranslucent by shadowTranslucentObject
    private val underwaterOverlayObject = bool("underwaterOverlay", false)
    val underwaterOverlay by underwaterOverlayObject
    private val sunObject = bool("sun", false)
    val sun by sunObject
    private val moonObject = bool("moon", false)
    val moon by moonObject
    private val vignetteObject = bool("vignette", false)
    val vignette by vignetteObject

    private val backFaceSolidObject = bool("backFace.solid", false)
    val backFaceSolid by backFaceSolidObject
    private val backFaceCutoutObject = bool("backFace.cutout", false)
    val backFaceCutout by backFaceCutoutObject
    private val backFaceCutoutMippedObject = bool("backFace.cutoutMipped", false)
    val backFaceCutoutMipped by backFaceCutoutMippedObject
    private val backFaceTranslucentObject = bool("backFace.translucent", false)
    val backFaceTranslucent by backFaceTranslucentObject

    private val rainDepthObject = bool("rain.depth", false)
    val rainDepth by rainDepthObject
    private val separateAoObject = bool("separateAo", false)
    val separateAo by separateAoObject
    private val frustumCullingObject = bool("frustum.culling", false)
    val frustumCulling by frustumCullingObject

    val globalGroup = group("Global", arrayOf(
        clouds, oldLightingObject, oldHandlightObject, dynamicHandlightObject, shadowTranslucentObject,
        underwaterOverlayObject, sunObject, moonObject, vignetteObject, backFaceSolidObject, backFaceCutoutObject,
        backFaceCutoutMippedObject, backFaceTranslucentObject, rainDepthObject, separateAoObject, frustumCullingObject
    ))

    val shaderValues = mutableListOf<Value<*>>()
    val reducedValues = mutableListOf<Value<*>>()
    val components = mutableListOf<AbstractOptionValueComponent<*>>()

    val scrollUtils = ScrollUtils()

    override fun initValues() {
        val groupValues = values.filterIsInstance<GroupValue>().flatMap { it.value.toList() }
        val reducedValues = values - groupValues.toSet()
        components.addAll(reducedValues.mapNotNull { OptionManager.getOptionComponent(it) })
    }

    fun createComponentFromImportedValues(pack: AbstractShaderPack) {
        val groupValueNames = shaderValues.filterIsInstance<GroupValue>().flatMap { it.value.toList() }.map { it.name }
        val values = shaderValues.toMutableList()
        values.removeIf { it.name in groupValueNames }

        reducedValues.addAll(values)
        components.addAll(reducedValues.mapNotNull { pack.getShaderComponent(it) })
    }
}