package net.optifine.shaders.gui

import net.bloom.bloomclient.value.Value
import net.bloom.bloomclient.value.values.GroupValue
import net.bloom.bloomclient.value.values.shaders.ShaderBoolValue
import net.bloom.bloomclient.value.values.shaders.ShaderListValue
import net.bloom.bloomclient.value.values.shaders.ShaderSliderValue
import net.minecraft.client.gui.options.value.*
import net.minecraft.client.option.OptionManager
import net.minecraft.client.resources.LanguageManager
import net.optifine.shaders.file.AbstractShaderPack
import java.io.Serializable

class ShaderOptionListValueComponent(value: ShaderListValue, private val pack: AbstractShaderPack): OptionListValueComponent(value) {
    override val displayedName: String
        get() {
            val id = "option.${value.name}"
            return pack.langProperties.getOrDefault(id, LanguageManager.format(id))
        }
    
}

class ShaderOptionBoolValueComponent(value: ShaderBoolValue, private val pack: AbstractShaderPack): OptionBoolValueComponent(value) {
    override val displayedName: String
        get() {
            val id = "option.${value.name}"
            return pack.langProperties.getOrDefault(id, LanguageManager.format(id))
        }

}

class ShaderOptionSliderValueComponent(value: ShaderSliderValue, private val pack: AbstractShaderPack): OptionIntegerValueComponent(value) {
    override val displayedName: String
        get() {
            val id = "option.${value.name}"
            return pack.langProperties.getOrDefault(id, LanguageManager.format(id))
        }

}

class ShaderOptionGroupValueComponent(value: GroupValue, private val pack: AbstractShaderPack): OptionGroupValueComponent(value) {
    override val components = value.value.mapNotNull {
        pack.getShaderComponent(it).also {component ->
            if (component is OptionGroupValueComponent) component.marginLeft = this.marginLeft + 8f
        }
    }.toList()

    override val displayedName: String
        get() = pack.langProperties.getOrDefault(value.name, LanguageManager.format(value.name))

}