package net.optifine.shaders.file

import net.optifine.util.StrUtils
import java.io.File
import java.util.*
import java.util.zip.ZipFile

class ZipShaderPack(name: String, private val file: File): AbstractShaderPack(name) {

    private var packZipFile: ZipFile? = null
    private var baseFolder = ""

    override fun getResourceAsStream(resourceName: String?) = runCatching {
        val packZipFile = this.packZipFile ?: ZipFile(file).also {
            baseFolder = detectBaseFolder(it)
            this.packZipFile = it
        }

        var path = StrUtils.removePrefix(resourceName, "/")

        if (path.contains(".."))
            path = this.resolveRelative(path)

        packZipFile.getEntry(baseFolder + path)?.let {
            packZipFile.getInputStream(it)
        }
    }.getOrNull()

    private fun resolveRelative(name: String): String {
        val elements = ArrayDeque<String>()

        for (item in name.split("/")) {
            if (item == "..") {
                if (elements.isEmpty())
                    return ""

                elements.removeLast()
            } else {
                elements.add(item)
            }
        }

        return elements.joinToString("/")
    }

    private fun detectBaseFolder(zip: ZipFile): String {
        val shaderRoot = zip.getEntry("shaders/")

        if (shaderRoot == null || !shaderRoot.isDirectory)
            for (file in zip.entries()) {
                val name = file.name

                if (name.contains("shaders/", true))
                    return if (name == "shaders/") "" else name
            }

        return ""
    }

    override fun hasDirectory(name: String?) = runCatching {
        val packZipFile = this.packZipFile ?: ZipFile(file).also {
            baseFolder = detectBaseFolder(it)
            this.packZipFile = it
        }

        val path = StrUtils.removePrefix(name, "/")
        val zipentry = packZipFile.getEntry(this.baseFolder + path)
        zipentry != null
    }.getOrNull() ?: false

    override fun close() {
        packZipFile?.let {
            it.close()
            packZipFile = null
        }
    }
}