package net.optifine.shaders.file

import net.optifine.util.StrUtils
import java.io.File
import java.io.InputStream

class FolderShaderPack(name: String, private val shaderFolder: File): AbstractShaderPack(name) {
    override fun getResourceAsStream(resourceName: String?): InputStream? = runCatching {
        val strippedResourceName = StrUtils.removePrefixSuffix(resourceName, "/", "/")
        val file = File(shaderFolder.absolutePath, strippedResourceName)

        if (!file.exists())
            null
        else
            file.inputStream().buffered()
    }.getOrNull()

    override fun hasDirectory(name: String?): Boolean {
        name ?: return false

        val file = File(shaderFolder, name.substring(1))
        return file.exists() && file.isDirectory()
    }

    override fun close() {}
}