package net.optifine.shaders

import net.bloom.bloomclient.utils.io.FileUtils
import net.minecraft.client.MinecraftInstance
import net.optifine.shaders.file.*
import java.io.File
import java.util.TreeSet

object ShaderManager: MinecraftInstance() {
    val shaderPacks = TreeSet<AbstractShaderPack> { pack1, pack2 -> if (pack1.priority == pack2.priority) pack1.name.compareTo(pack2.name) else pack1.priority.compareTo(pack2.priority) }
    @JvmField val shaderFolder = FileUtils.makeFolder(mc.mcDataDir, "shaders")
    private val shaderPackFolder = FileUtils.makeFolder(shaderFolder, "packs")
    val shaderConfigFolder = FileUtils.makeFolder(shaderFolder, "configs")
    @JvmField val debugFolder = FileUtils.makeFolder(shaderFolder, "debug")

    val builtInPacks = setOf(NoneShaderPack, DefaultShaderPack)
    @JvmField var shaderPack: AbstractShaderPack = NoneShaderPack

    init {
        shaderPacks.addAll(builtInPacks)
    }

    fun watchdogFindShaderpacks() {
        val files = shaderPackFolder.listFiles()?.toSet() ?: emptySet()
        shaderPacks.removeIf { pack -> pack !in builtInPacks && !packExists(pack, files) }

        for (file in files) {
            val name = file.name.trim { it <= ' '}

            if (shaderPacks.any { it.name == name })
                continue

            if (file.isDirectory) {
                val shadersFolder = File(file, "shaders")
                if (shadersFolder.exists() && shadersFolder.isDirectory)
                    FolderShaderPack(name, file).also {
                        shaderPacks.add(it)
                        it.load()
                    }

            } else if (file.isFile && file.extension == "zip")
                ZipShaderPack(name, file).also {
                    shaderPacks.add(it)
                    it.load()
                }
        }
    }

    private fun packExists(pack: AbstractShaderPack, existingFiles: Set<File>): Boolean {
        return when (pack) {
            is FolderShaderPack -> existingFiles.any { it.isDirectory && it.name == pack.name }
            is ZipShaderPack -> existingFiles.any { it.isFile && it.name == pack.name }
            else -> false
        }
    }

}