package net.minecraft.util

data class Vector3Pos(var x: Double, var y: Double, var z: Double) {

	operator fun plus(vector: Vector3Pos) = Vector3Pos(x + vector.x, y + vector.y, z + vector.z)

	operator fun minus(vector: Vector3Pos) = Vector3Pos(x - vector.x, y - vector.y, z - vector.z)

	operator fun unaryMinus() = Vector3Pos(-x, -y, -z)

	operator fun times(k: Double) = Vector3Pos(x * k, y * k, z * k)

	operator fun div(k: Double) = Vector3Pos(x / k, y / k, z / k)

	fun multiplier(k: Double) {
		x *= k
		y *= k
		z *= k
	}

	fun add(vector: Vector3Pos) {
		x += vector.x
		y += vector.y
		z += vector.z
	}

	fun set(x: Double, y: Double, z: Double) {
		this.x = x
		this.y = y
		this.z = z
	}
}