package net.minecraft.util

data class Vector2Pos(var x: Double, var z: Double) {

	operator fun plus(vector: Vector2Pos) = Vector2Pos(x + vector.x, z + vector.z)

	operator fun minus(vector: Vector2Pos) = Vector2Pos(x - vector.x, z - vector.z)

	operator fun unaryMinus() = Vector2Pos(-x, -z)

	operator fun times(k: Double) = Vector2Pos(x * k, z * k)

	operator fun div(k: Double) = Vector2Pos(x / k, z / k)
}