package net.minecraft.util

import net.minecraft.client.MinecraftInstance

data class Rotation(var yaw: Float, var pitch: Float): MinecraftInstance() {
    val isInvalidRotation: Boolean
        get() = yaw.isNaN() || pitch.isNaN() || pitch < -90.0 || pitch > 90.0
}