package net.minecraft.client.option.options.videosettings

import net.minecraft.client.option.MinecraftOption
import net.minecraft.client.option.options.ActionQueue
import net.minecraft.src.Config
import net.optifine.*

object TexturesOption: MinecraftOption("Textures") {

    @JvmStatic val fireEffect by float("Fire alpha", 0.3f, 0f, 1f)
    @JvmStatic val fireHeight by float("Fire height", 0f, -0.5f, 1.5f)
    @JvmStatic val hideFireOverlayWithFireResistance by bool("Hide fire overlay with Fire Resistance", true)

    @JvmStatic val isClearWater by bool("options.clear_water", false).onPostChange { _, newValue ->
        if (Config.isIntegratedServerRunning())
            Config.waterOpacityChanged = true

        ClearWater.updateWaterOpacity(newValue, mc.theWorld)
    }

    private val betterGrass = listOption("options.better_grass", "options.off", arrayOf("options.fancy", "options.fast", "options.off")) {
        ActionQueue.isNeedMinecraftLoadRenderers = true
    }

    @JvmStatic val isBetterSnow by boolOption("options.better_snow", false) {
        ActionQueue.isNeedMinecraftLoadRenderers = true
    }

    @JvmStatic val isCustomSky by boolOption("options.custom_sky", false) { CustomSky.update() }
    @JvmStatic val isCustomItems by boolOption("options.custom_items", true) { ActionQueue.isNeedMinecraftLoadRenderers = true }
    @JvmStatic val isCustomGUIs by boolOption("options.custom_guis", false) { CustomGuis.update() }
    @JvmStatic val isCustomEntityModels by boolOption("options.custom_entity_models", true) { ActionQueue.isNeedMinecraftRefreshResources = true }

    val connectedTextures = list("options.connected_textures", "options.fancy", arrayOf("options.fancy", "options.fast", "options.off")).onPostChange { _, newValue ->
        if (newValue.equals("options.fancy", true))
            ActionQueue.isNeedMinecraftLoadRenderers = true
        else
            ActionQueue.isNeedMinecraftRefreshResources = true
    }

    @JvmStatic val isNaturalTextures by boolOption("options.natural_textures", false) {
        NaturalTextures.update()
        ActionQueue.isNeedMinecraftLoadRenderers = true
    }

    @JvmStatic val isRandomEntities by boolOption("options.random_entities", true) { RandomEntities.update() }
    @JvmStatic val isEmissiveTextures by boolOption("options.emissive_textures", true) { ActionQueue.isNeedMinecraftRefreshResources = true }
    @JvmStatic val riddenHorseOpacity by float("Ridden horse opacity", 1f, 0f, 1f)

    @JvmStatic
    fun isBetterGrass() = betterGrass.equals("options.graphics.off")
    @JvmStatic
    fun isBetterGrassFancy() = betterGrass.equals("options.fancy")

}