package net.minecraft.client.option.options.videosettings

import net.bloom.bloomclient.value.values.ListValue
import net.minecraft.client.option.MinecraftOption
import net.minecraft.client.option.options.ActionQueue
import net.minecraft.client.option.options.ShadersOption
import net.minecraft.client.option.options.videosettings.TexturesOption.connectedTextures
import net.minecraft.client.option.options.videosettings.QualityOption.fancyGraphics
import net.minecraft.src.Config
import net.optifine.shaders.ShaderManager

object RenderOption: MinecraftOption("Render") {

    @JvmStatic val clouds by object: ListValue("options.renderClouds", arrayOf("options.default", "options.fast", "options.fancy", "options.off"), this) {
        override fun get(): String {
            val value = super.value

            if (value.equals("options.default", true))
                return if (fancyGraphics) "options.fancy" else "options.fast"

            return value
        }
    }.onPostChange { _, _ -> mc.renderGlobal.resetClouds() }

    @JvmStatic val cloudHeight by intOption("options.cloud_height", 0, 0, 100) { mc.renderGlobal.resetClouds() }
    private val trees = listOption("options.trees", "options.default", arrayOf("options.default", "general.smart", "options.fast", "options.fancy")) {
        ActionQueue.isNeedMinecraftLoadRenderers = true
    }

    private val rainAndSnow = list("options.rain", "options.default", arrayOf("options.default", "options.fast", "options.fancy", "options.off"))
    @JvmStatic val isSkyEnabled by bool("options.sky", false)
    @JvmStatic val isStarsEnabled by bool("options.stars", false)
    @JvmStatic val isSunMoonEnabled by bool("options.sun_moon", false)
    private val fog = object: ListValue("options.fog_fancy", arrayOf("options.fast", "options.fancy", "options.off"), this) {
        override fun get(): String {
            val value = super.value

            if (value.equals("options.fancy", true) && !Config.isFancyFogAvailable())
                return "options.off"

            return value
        }
    }

    @JvmStatic val fogStart by float("options.fog_start", 0.2f, 0f, 0.8f)
    @JvmStatic val isHeldItemTooltips by bool("options.held_item_tooltips", false)

    @JvmStatic val isAlternateBlocks by boolOption("options.blockAlternatives", true) { ActionQueue.isNeedMinecraftLoadRenderers = true }
    @JvmStatic val isHideAuraOnInvisibleWither by bool("Hide aura on invisible wither", true)

    @JvmStatic val isParallaxFix by bool("Parallax fix", true)
    @JvmStatic val isNoRenderCrosshairIfPlayerNotInFirstPerson by bool("Don't render crosshair if player isn't in first person", true)

    @JvmStatic val playerVoidRendering by bool("PlayerVoidRendering", true)
    @JvmStatic val isLeftHandInFirstPerson by bool("LeftHandInFirstPerson", true)
    @JvmStatic var isRenderingItemInFirstPerson = false

    @JvmStatic val isHideNametagOnF1 by bool("HideNametagOnF1", true)

    /**
     * JVM static functions
     */

    @JvmStatic
    fun isFogFancy() = Config.isFancyFogAvailable() && fog.equals("options.fancy")
    @JvmStatic
    fun isFogFast() = fog.equals("options.fast")
    @JvmStatic
    fun isFogOff() = fog.equals("options.off")
    @JvmStatic
    fun isFogOn() = !fog.equals("options.off")
    @JvmStatic
    fun isRainFancy() = if (rainAndSnow.equals("options.default")) fancyGraphics else rainAndSnow.equals("options.fancy")
    @JvmStatic
    fun isRainOff() = rainAndSnow.equals("options.off")
    @JvmStatic
    fun isCloudsFancy() = when (clouds.lowercase()) {
        "options.default" -> if (Config.isShaders() && !ShaderManager.shaderPack.options.clouds.equals("options.default"))
            ShaderManager.shaderPack.options.clouds.equals("options.fancy")
        else if (Config.texturePackClouds != 0)
            Config.texturePackClouds == 2
        else
            fancyGraphics

        "options.fancy" -> true
        else -> false
    }
    @JvmStatic
    fun isCloudsOff() = when (clouds.lowercase()) {
        "options.default" -> if (Config.isShaders() && !ShaderManager.shaderPack.options.clouds.equals("options.default"))
            ShaderManager.shaderPack.options.clouds.equals("options.off")
        else
            Config.texturePackClouds == 3

        "options.graphics.off" -> true
        else -> false
    }
    @JvmStatic
    fun isTreesFancy() = if (trees.equals("options.default")) fancyGraphics else !trees.equals("options.fast")
    @JvmStatic
    fun isTreesSmart() = trees.equals("general.smart")

    @JvmStatic
    fun isSunTexture() = isSunMoonEnabled && (!Config.isShaders() || ShadersOption.isSun())
    @JvmStatic
    fun isMoonTexture() = isSunMoonEnabled && (!Config.isShaders() || ShadersOption.isMoon())

    @JvmStatic
    fun isConnectedTextures() = !connectedTextures.equals("options.off")
    @JvmStatic
    fun isConnectedTexturesFancy() = connectedTextures.equals("options.fancy")

}