package net.minecraft.client.option.options.videosettings

import net.bloom.bloomclient.value.values.BoolValue
import net.minecraft.client.option.MinecraftOption
import net.minecraft.client.option.options.ActionQueue
import net.minecraft.src.Config

object PerformanceOption: MinecraftOption("Performance") {

    @JvmStatic val isUseVBO by boolOption("options.vbo", true) { ActionQueue.isNeedMinecraftLoadRenderers = true }
    @JvmStatic val isSmoothFPS by bool("options.smooth_fps", true)
    @JvmStatic val isFastRender by object: BoolValue("options.fast_render", false, this) {
        override fun get() = !Config.isShaders() && super.get()
    }.onPostChange { _, newValue ->
        if (newValue)
            ActionQueue.isNeedMinecraftLoadRenderers = true
        Config.updateFramebufferSize()
    }

    @JvmStatic var chunkUpdates by int("options.chunk_updates", 5, 1, 5)
    @JvmStatic val isRenderRegions by boolOption("options.render_regions", false) { ActionQueue.isNeedMinecraftLoadRenderers = true }
    @JvmStatic val smartAnimations by boolOption("options.smart_animations", false) { ActionQueue.isNeedMinecraftLoadRenderers = true }
    @JvmStatic val isSmoothWorld by boolOption("options.smooth_world", true) { Config.updateThreadPriorities() }
    @JvmStatic val isFastMath by bool("options.fast_math", false)
    @JvmStatic var isLazyChunkLoading by bool("options.lazy_chunk_loading", true)

    @JvmStatic val isRemoveWorldProgress by bool("RemoveWorldProgress", true)
    @JvmStatic val isBatchModelRendering by bool("BatchModelRendering", true)
}