package net.minecraft.client.option.options.videosettings

import net.minecraft.client.option.MinecraftOption

object ParticlesOption: MinecraftOption("Particles") {

    @JvmStatic val isWaterAnimated by bool("options.animated_water", false)
    @JvmStatic val isLavaAnimated by bool("options.animated_lava", false)
    @JvmStatic val isFireAnimated by bool("options.animated_fire", false)
    @JvmStatic val isPortalAnimated by bool("options.animated_portal", false)
    @JvmStatic val isAnimatedRedstone by bool("options.animated_redstone", false)
    @JvmStatic val isAnimatedExplosion by bool("options.animated_explosion", false)
    @JvmStatic val isAnimatedFlame by bool("options.animated_flame", false)
    @JvmStatic val isAnimatedSmoke by bool("options.animated_smoke", false)
    @JvmStatic val isVoidParticles by bool("options.void_particles", false)
    @JvmStatic val isWaterParticles by bool("options.water_particles", false)
    @JvmStatic val isRainSplash by bool("options.rain_splash", false)
    @JvmStatic val isPortalParticles by bool("options.portal_particles", false)
    @JvmStatic val isPotionParticles by bool("options.potion_particles", false)
    @JvmStatic val isDrippingWaterLava by bool("options.dripping_water_lava", false)
    @JvmStatic val isAnimatedTerrain by bool("options.animated_terrain", false)
    @JvmStatic val isAnimatedTextures by bool("options.animated_textures", false)
    @JvmStatic val isFireworkParticles by bool("options.firework_particles", false)
    @JvmStatic var particles by list("options.particles", "options.particles.all", arrayOf("options.particles.all", "options.particles.decreased", "options.particles.minimal"))
}