package net.minecraft.client.option.options.general

import net.minecraft.client.option.MinecraftOption

object WorldOption: MinecraftOption("World") {

    @JvmStatic val isWeatherEnabled by bool("options.weather", true)
    val time = list("options.time", "options.default", arrayOf("options.default", "options.time.dayonly", "options.time.nightonly"))
    @JvmStatic val isNumericalEnchanment by bool("NumericalEnchanment", true)
    @JvmStatic val isBetterRomanNumerals by bool("BetterRomanNumerals", true)

    /**
     * JVM static function
     */
    @JvmStatic
    fun isTimeDayOnly() = time.equals("options.time.dayonly")
    @JvmStatic
    fun isTimeDefault() = time.equals("options.default")
    @JvmStatic
    fun isTimeNightOnly() = time.equals("options.time.nightonly")

}