package net.minecraft.client.option.options.general

import net.minecraft.client.option.MinecraftOption
import net.minecraft.client.option.options.ActionQueue

object SkinOption: MinecraftOption("Skin") {

    private val cape by boolOption("options.modelPart.cape", false) { ActionQueue.isNeedMinecraftReloadSkinSetting = true  }
    private val jacket by boolOption("options.modelPart.jacket", false) { ActionQueue.isNeedMinecraftReloadSkinSetting = true  }
    private val leftSleeve by boolOption("options.modelPart.left_sleeve", false) { ActionQueue.isNeedMinecraftReloadSkinSetting = true  }
    private val rightSleeve by boolOption("options.modelPart.right_sleeve", false) { ActionQueue.isNeedMinecraftReloadSkinSetting = true  }
    private val leftPantsLeg by boolOption("options.modelPart.left_pants_leg", false) { ActionQueue.isNeedMinecraftReloadSkinSetting = true  }
    private val rightPantsLeg by boolOption("options.modelPart.right_pants_leg", false) { ActionQueue.isNeedMinecraftReloadSkinSetting = true  }
    private val hat by boolOption("options.modelPart.hat", false) { ActionQueue.isNeedMinecraftReloadSkinSetting = true  }
    @JvmStatic val isShowCapes by bool("options.show_capes", false)

    @JvmStatic
    val partMask: Int
        get() {
            var i = 0

            if (cape) i = i or (1 shl 0)
            if (jacket) i = i or (1 shl 1)
            if (leftSleeve) i = i or (1 shl 2)
            if (rightSleeve) i = i or (1 shl 3)
            if (leftPantsLeg) i = i or (1 shl 4)
            if (rightPantsLeg) i = i or (1 shl 5)
            if (hat) i = i or (1 shl 6)

            return i
        }
}