package net.minecraft.client.option.options.general

import net.bloom.bloomclient.value.values.BoolValue
import net.bloom.bloomclient.value.values.IntegerValue
import net.bloom.bloomclient.value.values.ListValue
import net.minecraft.client.option.*
import net.minecraft.client.option.options.ActionQueue
import net.minecraft.client.renderer.OpenGlHelper
import net.minecraft.client.resources.LanguageManager
import net.minecraft.src.Config

object OtherOption: MinecraftOption("Other") {
    @JvmStatic val isAnaglyph3D by object: BoolValue("options.anaglyph", false, this) {
        override fun get() = !Config.isShaders() && super.value
    }

    @JvmStatic val screenshotSize by object: IntegerValue("options.screenshot_size", 1, 1, 4, this) {
        override fun get() = if (!OpenGlHelper.isFramebufferEnabled()) 1 else super.value

        override val displayedValue: String
            get() = when (temporaryValue) {
                1 -> LanguageManager.format("options.default")
                else -> "${temporaryValue}x"
            }
    }

    @JvmStatic val fullscreenObject = boolOption("options.fullscreen", false) { mc.toggleFullscreen() }
    @JvmStatic val isFullscreen by fullscreenObject

    @JvmStatic val fullscreenModeObject = list("options.fullscreen_mode", "320x240", Config.getDisplayModeNames())
    @JvmStatic val fullscreenMode by fullscreenModeObject

    @JvmStatic val isAdvancedTooltipsObject = bool("options.advanced_tooltips", false)
    @JvmStatic val isAdvancedTooltips by isAdvancedTooltipsObject

    @JvmStatic val autosave by object: IntegerValue("options.autosave_ticks", 0, 1, 120, this) {
        override fun get() = super.value * 1200

        override val displayedValue: String
            get() = when (temporaryValue) {
                0 -> LanguageManager.format("options.off")
                1 -> LanguageManager.format("options.autosave.1min")
                else -> "$temporaryValue mins"
            }
    }

    @JvmStatic val languageObject = object: ListValue("options.language", "en_US", arrayOf("en_US"), this) {
        override val displayedValue: String
            get() = mc.languageManager.getLanguageByLanguageCode(temporaryValue).toString()
    }.also {
        it.onPostChange { _, _ -> ActionQueue.isNeedMinecraftRefreshResources = true }
    }


    @JvmStatic var language by languageObject

    @JvmStatic val isUseUnicode by bool("options.useUnicode", false).onPostChange { _, newValue ->
        mc.minecraftFontRendererObj.unicodeFlag = newValue
    }
}