package net.minecraft.client.option.options.general

import net.bloom.bloomclient.features.module.modules.render.ModuleFullBright
import net.bloom.bloomclient.utils.ClientUtils
import net.bloom.bloomclient.value.values.IntegerValue
import net.minecraft.client.gui.ScaledResolution
import net.minecraft.client.option.MinecraftOption
import net.minecraft.client.resources.LanguageManager
import net.minecraft.src.Config
import org.lwjgl.opengl.Display

object GeneralOption: MinecraftOption("General") {
    @JvmStatic var fOV by object: IntegerValue("options.fov", 70, 30, 120, this) {
        override val displayedValue: String
            get() = when (temporaryValue) {
                30 -> LanguageManager.format("options.fov.min")
                110 -> LanguageManager.format("options.fov.max")
                else -> super.displayedValue
            }
    }

    @JvmStatic val dynamicFOV by bool("options.dynamic_fov", false)

    @JvmStatic var renderDistance by object: IntegerValue("options.renderDistance", 2, 2, ClientUtils.getMaxDistanceByRam(), this) {
        override val displayedValue: String
            get() {
                val (distanceRange, type) = when {
                    temporaryValue >= 64 -> 64 to LanguageManager.format("options.renderDistance.ludicrous")
                    temporaryValue >= 48 -> 48 to LanguageManager.format("options.renderDistance.insane")
                    temporaryValue >= 32 -> 32 to LanguageManager.format("options.renderDistance.extreme")
                    temporaryValue >= 16 -> 16 to LanguageManager.format("options.renderDistance.far")
                    temporaryValue >= 8 -> 8 to LanguageManager.format("options.renderDistance.normal")
                    temporaryValue >= 4 -> 4 to LanguageManager.format("options.renderDistance.short")
                    else -> 2 to LanguageManager.format("options.renderDistance.tiny")
                }

                return "$temporaryValue $type${if (temporaryValue - distanceRange > 0) "+" else ""}"
            }
    }.onPostChange { _, _ -> mc.renderGlobal.setDisplayListEntitiesDirty() }

    val framerate = object: IntegerValue("options.framerateLimit", 60, 1, 261, this) {
        override fun get() = if (vsync) maxRange else super.value

        override val displayedValue: String
            get() = if (temporaryValue == 261) LanguageManager.format("options.framerateLimit.max") else super.displayedValue
    }

    @JvmStatic val vsyncObject = bool("options.vsync", false).onPostChange { _, newValue -> Display.setVSyncEnabled(newValue) }
    @JvmStatic val vsync by vsyncObject

    @JvmStatic val brightness by object: IntegerValue("options.gamma", 100, 0, 100, this) {
        override fun get() = if (ModuleFullBright.state && ModuleFullBright.mode == "Gamma") 10000 else super.value

        override val displayedValue: String
            get() = when (temporaryValue) {
                0 -> LanguageManager.format("options.gamma.min")
                100 -> LanguageManager.format("options.gamma.max")
                else -> super.displayedValue
            }
    }

    @JvmStatic var guiScale by object: IntegerValue("options.guiScale", 2, 0, 3, this) {
        override val displayedValue: String
            get() = when (temporaryValue) {
                0 -> LanguageManager.format("options.guiScale.auto")
                1 -> LanguageManager.format("options.guiScale.small")
                2 -> LanguageManager.format("options.guiScale.normal")
                3 -> LanguageManager.format("options.guiScale.large")
                else -> "${temporaryValue}x"
            }
    }.onPostChange { _, _ ->
        val scaledresolution = ScaledResolution(mc)
        mc.currentScreen?.setWorldAndResolution(mc, scaledresolution.scaledWidth, scaledresolution.scaledHeight)
    }

    @JvmStatic var viewBobbing by bool("options.viewBobbing", false)
    @JvmStatic var entityShadows by bool("options.entityShadows", false)
}