package net.minecraft.client.option.options.general

import net.minecraft.client.option.MinecraftOption

object DebuggingOption: MinecraftOption("Debugging") {

    @JvmStatic val isRenderCrosshairOnDebug by bool("RenderCrosshairOnDebug", true)
    @JvmStatic val isReduceDebugInfo by boolOption("options.reducedDebugInfo", true)
    @JvmStatic val isLagometer by bool("options.lagometer", false)
    @JvmStatic val isShowFPS by bool("options.show_fps", true)
    @JvmStatic val isRenderNormalFPSCounter by bool("Normal FPS counter", true)
    @JvmStatic val isDebugProfiler by bool("options.profiler", false)
    @JvmStatic val isShowGlErrors by bool("options.show_gl_errors", true)

    @JvmStatic val pauseOnLostFocusObject = bool("Don't pause on lost focus", true)
    @JvmStatic val isPauseOnLostFocus by pauseOnLostFocusObject

    @JvmStatic val isDebugCamEnabled by bool("Debug cam enable", false)


}