package net.minecraft.client.option.options.general

import net.minecraft.client.option.*
import net.minecraft.client.option.options.ActionQueue

object ChatOption: MinecraftOption("Chat") {

    @JvmStatic val chatVisibilityObject = list("options.chat.visibility", "options.chat.visibility.full", arrayOf("options.chat.visibility.full", "options.chat.visibility.system", "options.chat.visibility.hidden"))
    @JvmStatic val chatVisibility by chatVisibilityObject

    @JvmStatic val isChatColors by boolOption("options.chat.color", true)
    @JvmStatic val isChatLinks by boolOption("options.chat.links", true)
    @JvmStatic val isChatLinkPrompt by boolOption("options.chat.links.prompt", true)
    @JvmStatic val chatOpacity by intOption("options.chat.opacity", 0, 0, 100) { ActionQueue.isNeedRefreshChat = true }
    @JvmStatic val chatScale by intOption("options.chat.scale", 1, 1, 100) { ActionQueue.isNeedRefreshChat = true }
    @JvmStatic val chatFocusedHeight by intOption("options.chat.height.focused", 180, 20, 180) { ActionQueue.isNeedRefreshChat = true }
    @JvmStatic val chatUnfocusedHeight by intOption("options.chat.height.unfocused", 180, 20, 180) { ActionQueue.isNeedRefreshChat = true }
    @JvmStatic val chatWidth by intOption("options.chat.width", 320, 40, 320) { ActionQueue.isNeedRefreshChat = true }
}