package net.minecraft.client.option.options.devices

import net.bloom.bloomclient.value.values.FloatValue
import net.minecraft.client.audio.SoundCategory
import net.minecraft.client.option.MinecraftOption
import net.minecraft.client.resources.LanguageManager

object SoundOption: MinecraftOption("Sounds") {

    @JvmStatic val masterSoundObject = createSoundValue("soundCategory.master", SoundCategory.MASTER)
    @JvmStatic var masterSound by masterSoundObject
    @JvmStatic val musicSound by createSoundValue("soundCategory.music", SoundCategory.MUSIC)
    @JvmStatic val recordSound by createSoundValue("soundCategory.records", SoundCategory.RECORDS)
    @JvmStatic val weatherSound by createSoundValue("soundCategory.weather", SoundCategory.WEATHER)
    @JvmStatic val blockSound by createSoundValue("soundCategory.blocks", SoundCategory.BLOCKS)
    @JvmStatic val mobsSound by createSoundValue("soundCategory.mobs", SoundCategory.MOBS)
    @JvmStatic val animalsSound by createSoundValue("soundCategory.animals", SoundCategory.ANIMALS)
    @JvmStatic val playersSound by createSoundValue("soundCategory.players", SoundCategory.PLAYERS)
    @JvmStatic val ambientSound by createSoundValue("soundCategory.ambient", SoundCategory.AMBIENT)

    private fun createSoundValue(name: String, category: SoundCategory): FloatValue {
        return object: FloatValue(name, 1f, 0f, 1f, this) {
            override val displayedValue: String
                get() = when (temporaryValue) {
                    0f -> LanguageManager.format("options.off")
                    1f -> LanguageManager.format("general.max")
                    else -> "${(temporaryValue * 100).toInt()}%"
                }
        }.also {
            it.onPostChange {_, newValue -> mc.soundHandler.setSoundLevel(category, newValue) }
        }
    }

}