package net.minecraft.client.option.options.devices

import net.bloom.bloomclient.value.values.IntegerValue
import net.minecraft.client.option.MinecraftOption
import net.minecraft.client.resources.LanguageManager

object MouseOption: MinecraftOption("Mouse") {

    @JvmStatic val isInvertMouse by boolOption("options.invertMouse", false)
    @JvmStatic val isTouchscreen by boolOption("options.touchscreen", false)
    private var mouseSensitivityObject by object: IntegerValue("options.sensitivity", 1, 1, 200, this) {
        override val displayedValue: String
            get() = when (temporaryValue) {
                1 -> LanguageManager.format("options.sensitivity.min")
                200 -> LanguageManager.format("options.sensitivity.max")
                else -> "$temporaryValue%"
            }
    }

    val disableHotbarScrolling by bool("DisableHotbarScrolling", true)

    @JvmStatic
    var mouseSensitivity: Float
        get() = mouseSensitivityObject / 200f
        set(value) {
            mouseSensitivityObject = (value * 200).toInt()
        }

}