package net.minecraft.client.option.options.devices

import net.bloom.bloomclient.value.values.KeyValue
import net.minecraft.client.option.MinecraftOption
import org.lwjgl.input.Keyboard
import org.lwjgl.input.Mouse

object KeyBinding: MinecraftOption("Key mapping") {

    @JvmField val keyBindForward = key("key.forward", 17)
    @JvmField val keyBindLeft = key("key.left", 30)
    @JvmField val keyBindBack = key("key.back", 31)
    @JvmField val keyBindRight = key("key.right", 32)
    @JvmField val keyBindJump = key("key.jump", 57)
    @JvmField val keyBindSneak = key("key.sneak", 42)
    @JvmField val keyBindSprint = key("key.sprint", 29)
    @JvmField val keyBindInventory = key("key.inventory", 18)
    @JvmField val keyBindUseItem = key("key.use", -99)
    @JvmField val keyBindDrop = key("key.drop", 16)
    @JvmField val keyBindAttack = key("key.attack", -100)
    @JvmField val keyBindPickBlock = key("key.pickItem", -98)
    @JvmField val keyBindSwapOffHand = key("key.offHand", 33)
    @JvmField val keyBindChat = key("key.chat", 20)
    @JvmField val keyBindPlayerList = key("key.playerlist", 15)
    @JvmField val keyBindCommand = key("key.command", 53)
    @JvmField val keyBindScreenshot = key("key.screenshot", 60)
    @JvmField val keyBindTogglePerspective = key("key.togglePerspective", 63)
    @JvmField val keyBindSmoothCamera = key("key.smoothCamera", 0)
    @JvmField val keyBindFullscreen = key("key.fullscreen", 87)
    @JvmField val keyBindSpectatorOutlines = key("key.spectatorOutlines", 0)
    @JvmField val keyBindZoom = key("key.zoom", 46)
    @JvmField val keyBindSlot1 = key("key.hotbar.1", 2)
    @JvmField val keyBindSlot2 = key("key.hotbar.2", 3)
    @JvmField val keyBindSlot3 = key("key.hotbar.3", 4)
    @JvmField val keyBindSlot4 = key("key.hotbar.4", 5)
    @JvmField val keyBindSlot5 = key("key.hotbar.5", 6)
    @JvmField val keyBindSlot6 = key("key.hotbar.6", 7)
    @JvmField val keyBindSlot7 = key("key.hotbar.7", 8)
    @JvmField val keyBindSlot8 = key("key.hotbar.8", 9)
    @JvmField val keyBindSlot9 = key("key.hotbar.9", 10)
    @JvmField val keyBindsHotbar = arrayOf(keyBindSlot1, keyBindSlot2, keyBindSlot3, keyBindSlot4, keyBindSlot5, keyBindSlot6, keyBindSlot7, keyBindSlot8, keyBindSlot9)

    @JvmField val keybinds = arrayListOf(
        keyBindForward, keyBindLeft, keyBindBack, keyBindRight, keyBindJump, keyBindSneak, keyBindSprint, keyBindInventory, keyBindUseItem,
        keyBindDrop, keyBindAttack, keyBindPickBlock, keyBindChat, keyBindPlayerList, keyBindCommand, keyBindScreenshot, keyBindTogglePerspective,
        keyBindSmoothCamera, keyBindFullscreen, keyBindSpectatorOutlines, keyBindZoom, keyBindSlot1, keyBindSlot2, keyBindSlot3, keyBindSlot4,
        keyBindSlot5, keyBindSlot6, keyBindSlot7, keyBindSlot8, keyBindSlot9
    )

    fun onTick(keyCode: Int) {
        if (keyCode != 0) {
            val key = keybinds.find { it.value == keyCode } ?: return
            ++key.pressTime
        }
    }

    @JvmStatic
    fun setKeyBindState(keyCode: Int, pressed: Boolean) {
        if (keyCode != 0) {
            val key = keybinds.find { it.value == keyCode } ?: return
            key.isKeyDown = pressed
        }
    }

    @JvmStatic
    fun unpressAllKeys() {
        for (keybinding in keybinds)
            keybinding.unpressKey()
    }

    @JvmStatic
    fun isKeyDown(key: KeyValue): Boolean {
        val keyCode = key.value
        return if (keyCode != 0 && keyCode < 256)
            if (keyCode < 0)
                Mouse.isButtonDown(keyCode + 100)
            else Keyboard.isKeyDown(keyCode)
        else false
    }

}